/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.annotations.VisibleForTesting;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;

public class AppendEntriesReply
extends AbstractRaftRPC {
    private static final long serialVersionUID = -7487547356392536683L;
    private final boolean success;
    private final long logLastIndex;
    private final long logLastTerm;
    private final String followerId;
    private final short payloadVersion;
    private final short raftVersion;
    private final boolean forceInstallSnapshot;
    private final boolean needsLeaderAddress;
    private final short recipientRaftVersion;

    @VisibleForTesting
    public AppendEntriesReply(String followerId, long term, boolean success, long logLastIndex, long logLastTerm, short payloadVersion) {
        this(followerId, term, success, logLastIndex, logLastTerm, payloadVersion, false, false, 4);
    }

    public AppendEntriesReply(String followerId, long term, boolean success, long logLastIndex, long logLastTerm, short payloadVersion, boolean forceInstallSnapshot, boolean needsLeaderAddress, short recipientRaftVersion) {
        this(followerId, term, success, logLastIndex, logLastTerm, payloadVersion, forceInstallSnapshot, needsLeaderAddress, 4, recipientRaftVersion);
    }

    private AppendEntriesReply(String followerId, long term, boolean success, long logLastIndex, long logLastTerm, short payloadVersion, boolean forceInstallSnapshot, boolean needsLeaderAddress, short raftVersion, short recipientRaftVersion) {
        super(term);
        this.followerId = followerId;
        this.success = success;
        this.logLastIndex = logLastIndex;
        this.logLastTerm = logLastTerm;
        this.payloadVersion = payloadVersion;
        this.forceInstallSnapshot = forceInstallSnapshot;
        this.raftVersion = raftVersion;
        this.needsLeaderAddress = needsLeaderAddress;
        this.recipientRaftVersion = recipientRaftVersion;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getLogLastIndex() {
        return this.logLastIndex;
    }

    public long getLogLastTerm() {
        return this.logLastTerm;
    }

    public String getFollowerId() {
        return this.followerId;
    }

    public short getPayloadVersion() {
        return this.payloadVersion;
    }

    public short getRaftVersion() {
        return this.raftVersion;
    }

    public boolean isForceInstallSnapshot() {
        return this.forceInstallSnapshot;
    }

    public boolean isNeedsLeaderAddress() {
        return this.needsLeaderAddress;
    }

    public String toString() {
        return "AppendEntriesReply [term=" + this.getTerm() + ", success=" + this.success + ", followerId=" + this.followerId + ", logLastIndex=" + this.logLastIndex + ", logLastTerm=" + this.logLastTerm + ", forceInstallSnapshot=" + this.forceInstallSnapshot + ", needsLeaderAddress=" + this.needsLeaderAddress + ", payloadVersion=" + this.payloadVersion + ", raftVersion=" + this.raftVersion + ", recipientRaftVersion=" + this.recipientRaftVersion + "]";
    }

    private Object writeReplace() {
        return this.recipientRaftVersion >= 4 ? new Proxy2(this) : new Proxy(this);
    }

    @Deprecated
    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private AppendEntriesReply appendEntriesReply;

        public Proxy() {
        }

        Proxy(AppendEntriesReply appendEntriesReply) {
            this.appendEntriesReply = appendEntriesReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.appendEntriesReply.raftVersion);
            out.writeLong(this.appendEntriesReply.getTerm());
            out.writeObject(this.appendEntriesReply.followerId);
            out.writeBoolean(this.appendEntriesReply.success);
            out.writeLong(this.appendEntriesReply.logLastIndex);
            out.writeLong(this.appendEntriesReply.logLastTerm);
            out.writeShort(this.appendEntriesReply.payloadVersion);
            out.writeBoolean(this.appendEntriesReply.forceInstallSnapshot);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short raftVersion = in.readShort();
            long term = in.readLong();
            String followerId = (String)in.readObject();
            boolean success = in.readBoolean();
            long logLastIndex = in.readLong();
            long logLastTerm = in.readLong();
            short payloadVersion = in.readShort();
            boolean forceInstallSnapshot = in.readBoolean();
            this.appendEntriesReply = new AppendEntriesReply(followerId, term, success, logLastIndex, logLastTerm, payloadVersion, forceInstallSnapshot, false, raftVersion, 4);
        }

        private Object readResolve() {
            return this.appendEntriesReply;
        }
    }

    private static class Proxy2
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private AppendEntriesReply appendEntriesReply;

        public Proxy2() {
        }

        Proxy2(AppendEntriesReply appendEntriesReply) {
            this.appendEntriesReply = appendEntriesReply;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.appendEntriesReply.raftVersion);
            out.writeLong(this.appendEntriesReply.getTerm());
            out.writeObject(this.appendEntriesReply.followerId);
            out.writeBoolean(this.appendEntriesReply.success);
            out.writeLong(this.appendEntriesReply.logLastIndex);
            out.writeLong(this.appendEntriesReply.logLastTerm);
            out.writeShort(this.appendEntriesReply.payloadVersion);
            out.writeBoolean(this.appendEntriesReply.forceInstallSnapshot);
            out.writeBoolean(this.appendEntriesReply.needsLeaderAddress);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short raftVersion = in.readShort();
            long term = in.readLong();
            String followerId = (String)in.readObject();
            boolean success = in.readBoolean();
            long logLastIndex = in.readLong();
            long logLastTerm = in.readLong();
            short payloadVersion = in.readShort();
            boolean forceInstallSnapshot = in.readBoolean();
            boolean needsLeaderAddress = in.readBoolean();
            this.appendEntriesReply = new AppendEntriesReply(followerId, term, success, logLastIndex, logLastTerm, payloadVersion, forceInstallSnapshot, needsLeaderAddress, raftVersion, 4);
        }

        private Object readResolve() {
            return this.appendEntriesReply;
        }
    }
}

