/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.doc.impl;

import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.sal.rest.doc.impl.BaseYangSwaggerGenerator;

public abstract class BaseYangSwaggerGeneratorRFC8040
extends BaseYangSwaggerGenerator {
    private static final String DEFAULT_BASE_PATH = "rests";
    private final String basePath;

    protected BaseYangSwaggerGeneratorRFC8040(Optional<DOMSchemaService> schemaService) {
        super(schemaService);
        this.basePath = DEFAULT_BASE_PATH;
    }

    protected BaseYangSwaggerGeneratorRFC8040(Optional<DOMSchemaService> schemaService, String basePath) {
        super(schemaService);
        this.basePath = basePath;
    }

    @Override
    public String getDataStorePath(String dataStore, String context) {
        if ("config".contains(dataStore) || "operational".contains(dataStore)) {
            return "/" + this.basePath + "/data" + context;
        }
        return "/" + this.basePath + "/operations" + context;
    }

    @Override
    public String getContent(String dataStore) {
        if ("operational".contains(dataStore)) {
            return "?content=nonconfig";
        }
        if ("config".contains(dataStore)) {
            return "?content=config";
        }
        return "";
    }

    @Override
    protected BaseYangSwaggerGenerator.ListPathBuilder newListPathBuilder() {
        return new BaseYangSwaggerGenerator.ListPathBuilder(){
            private String prefix = "=";

            @Override
            public String nextParamIdentifier(String key) {
                String str = this.prefix + "{" + key + "}";
                this.prefix = ",";
                return str;
            }
        };
    }

    @Override
    protected void appendPathKeyValue(StringBuilder builder, Object value) {
        builder.deleteCharAt(builder.length() - 1).append("=").append(value).append('/');
    }
}

