/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.concurrent.ThreadLocalRandom;
import tech.pantheon.triemap.BasicNode;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class CNode<K, V>
extends MainNode<K, V> {
    private static final BasicNode[] EMPTY_ARRAY = new BasicNode[0];
    final int bitmap;
    final BasicNode[] array;
    final Gen gen;
    private volatile int csize = -1;

    private CNode(Gen gen, int bitmap, BasicNode ... array) {
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }

    CNode(Gen gen) {
        this(gen, 0, EMPTY_ARRAY);
    }

    static <K, V> MainNode<K, V> dual(SNode<K, V> snode, K key, V value, int hc, int lev, Gen gen) {
        return CNode.dual(snode, snode.hc, new SNode<K, V>(key, value, hc), hc, lev, gen);
    }

    private static <K, V> MainNode<K, V> dual(SNode<K, V> first, int firstHash, SNode<K, V> second, int secondHash, int lev, Gen gen) {
        if (lev >= 32) {
            return new LNode(first.key, first.value, second.key, second.value);
        }
        int xidx = firstHash >>> lev & 0x1F;
        int yidx = secondHash >>> lev & 0x1F;
        int bmp = 1 << xidx | 1 << yidx;
        if (xidx == yidx) {
            return new CNode<K, V>(gen, bmp, new INode<K, V>(gen, CNode.dual(first, firstHash, second, secondHash, lev + 5, gen)));
        }
        return xidx < yidx ? new CNode<K, V>(gen, bmp, first, second) : new CNode<K, V>(gen, bmp, second, first);
    }

    @Override
    int trySize() {
        return this.csize;
    }

    @Override
    int size(ImmutableTrieMap<?, ?> ct) {
        int sz = this.csize;
        return sz != -1 ? sz : (this.csize = this.computeSize(ct));
    }

    static VerifyException invalidElement(BasicNode elem) {
        throw new VerifyException("A CNode can contain only CNodes and SNodes, not %s", elem);
    }

    private int computeSize(ImmutableTrieMap<?, ?> ct) {
        int i;
        int len = this.array.length;
        switch (len) {
            case 0: {
                return 0;
            }
            case 1: {
                return CNode.elementSize(this.array[0], ct);
            }
        }
        int offset = ThreadLocalRandom.current().nextInt(len);
        int sz = 0;
        for (i = offset; i < len; ++i) {
            sz += CNode.elementSize(this.array[i], ct);
        }
        for (i = 0; i < offset; ++i) {
            sz += CNode.elementSize(this.array[i], ct);
        }
        return sz;
    }

    private static int elementSize(BasicNode elem, ImmutableTrieMap<?, ?> ct) {
        if (elem instanceof SNode) {
            return 1;
        }
        if (elem instanceof INode) {
            return ((INode)elem).size(ct);
        }
        throw CNode.invalidElement(elem);
    }

    CNode<K, V> updatedAt(int pos, BasicNode nn, Gen newGen) {
        int len = this.array.length;
        BasicNode[] narr = new BasicNode[len];
        System.arraycopy(this.array, 0, narr, 0, len);
        narr[pos] = nn;
        return new CNode<K, V>(newGen, this.bitmap, narr);
    }

    CNode<K, V> removedAt(int pos, int flag, Gen newGen) {
        BasicNode[] arr = this.array;
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len - 1];
        System.arraycopy(arr, 0, narr, 0, pos);
        System.arraycopy(arr, pos + 1, narr, pos, len - pos - 1);
        return new CNode<K, V>(newGen, this.bitmap ^ flag, narr);
    }

    CNode<K, V> insertedAt(int pos, int flag, BasicNode nn, Gen newGen) {
        int len = this.array.length;
        BasicNode[] narr = new BasicNode[len + 1];
        System.arraycopy(this.array, 0, narr, 0, pos);
        narr[pos] = nn;
        System.arraycopy(this.array, pos, narr, pos + 1, len - pos);
        return new CNode<K, V>(newGen, this.bitmap | flag, narr);
    }

    CNode<K, V> renewed(Gen ngen, TrieMap<K, V> ct) {
        BasicNode[] arr = this.array;
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len];
        for (int idx = 0; idx < len; ++idx) {
            BasicNode elem = arr[idx];
            if (elem instanceof INode) {
                narr[idx] = ((INode)elem).copyToGen(ngen, ct);
                continue;
            }
            if (elem == null) continue;
            narr[idx] = elem;
        }
        return new CNode<K, V>(ngen, this.bitmap, narr);
    }

    MainNode<K, V> toContracted(int lev) {
        if (this.array.length == 1 && lev > 0) {
            if (this.array[0] instanceof SNode) {
                return ((SNode)this.array[0]).copyTombed();
            }
            return this;
        }
        return this;
    }

    MainNode<K, V> toCompressed(TrieMap<?, ?> ct, int lev, Gen newGen) {
        int bmp = this.bitmap;
        BasicNode[] arr = this.array;
        BasicNode[] tmparray = new BasicNode[arr.length];
        for (int idx = 0; idx < arr.length; ++idx) {
            BasicNode sub = arr[idx];
            if (sub instanceof INode) {
                INode in = (INode)sub;
                MainNode inodemain = VerifyException.throwIfNull(in.gcasRead(ct));
                tmparray[idx] = CNode.resurrect(in, inodemain);
                continue;
            }
            if (!(sub instanceof SNode)) continue;
            tmparray[idx] = sub;
        }
        return new CNode<K, V>(newGen, bmp, tmparray).toContracted(lev);
    }

    private static BasicNode resurrect(INode<?, ?> inode, MainNode<?, ?> inodemain) {
        return inodemain instanceof TNode ? ((TNode)inodemain).copyUntombed() : inode;
    }

    public String toString() {
        return "CNode";
    }
}

