/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import tech.pantheon.triemap.CheckUtil;
import tech.pantheon.triemap.Equivalence;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class SerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private TrieMap<Object, Object> map;
    private boolean readOnly;

    public SerializationProxy() {
    }

    SerializationProxy(ImmutableTrieMap<?, ?> map, boolean readOnly) {
        this.map = Objects.requireNonNull(map);
        this.readOnly = readOnly;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map.equiv());
        out.writeInt(this.map.size());
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
        out.writeBoolean(this.readOnly);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Equivalence equiv = CheckUtil.nonNullArgument((Equivalence)in.readObject());
        MutableTrieMap<Object, Object> tmp = new MutableTrieMap<Object, Object>(equiv);
        int size = in.readInt();
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < size; ++i) {
            tmp.add(in.readObject(), in.readObject());
        }
        this.map = in.readBoolean() ? tmp.immutableSnapshot() : tmp;
    }

    private Object readResolve() throws ObjectStreamException {
        return VerifyException.throwIfNull(this.map);
    }
}

