/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.closetracker.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTracked;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistry;

public class CloseTrackedTrait<T extends CloseTracked<T>>
implements CloseTracked<T> {
    private final @Nullable Throwable allocationContext;
    private final CloseTrackedRegistry<T> closeTrackedRegistry;
    private final CloseTracked<T> realCloseTracked;

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="SpotBugs and JDT annotations")
    public CloseTrackedTrait(CloseTrackedRegistry<T> transactionChainRegistry, CloseTracked<T> realCloseTracked) {
        this.allocationContext = transactionChainRegistry.isDebugContextEnabled() ? new Throwable() : null;
        this.realCloseTracked = Objects.requireNonNull(realCloseTracked, "realCloseTracked");
        this.closeTrackedRegistry = Objects.requireNonNull(transactionChainRegistry, "transactionChainRegistry");
        this.closeTrackedRegistry.add(this);
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public StackTraceElement[] getAllocationContextStackTrace() {
        return this.allocationContext != null ? this.allocationContext.getStackTrace() : null;
    }

    public void removeFromTrackedRegistry() {
        this.closeTrackedRegistry.remove(this);
    }

    @Override
    public CloseTracked<T> getRealCloseTracked() {
        return this.realCloseTracked;
    }
}

