/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.dom.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingBroker;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;

abstract class AbstractTracingWriteTransaction
implements DOMDataWriteTransaction {
    private final DOMDataWriteTransaction delegate;
    private final TracingBroker tracingBroker;
    private final List<String> logs = new ArrayList<String>();

    AbstractTracingWriteTransaction(DOMDataWriteTransaction delegate, TracingBroker tracingBroker) {
        this.delegate = Objects.requireNonNull(delegate);
        this.tracingBroker = Objects.requireNonNull(tracingBroker);
        this.recordOp(null, null, "instantiate", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordOp(LogicalDatastoreType store, YangInstanceIdentifier yiid, String method, NormalizedNode<?, ?> node) {
        Object value;
        if (yiid != null && !this.tracingBroker.isWriteWatched(yiid, store)) {
            return;
        }
        Object object = value = node != null ? node.getValue() : null;
        if (value != null && value instanceof ImmutableSet && ((Set)value).isEmpty()) {
            if (TracingBroker.LOG.isDebugEnabled()) {
                TracingBroker.LOG.debug("Empty data set write to {}", (Object)this.tracingBroker.toPathString(yiid));
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Method \"").append(method).append('\"');
            if (store != null) {
                sb.append(" to ").append(store);
            }
            if (yiid != null) {
                sb.append(" at ").append(this.tracingBroker.toPathString(yiid));
            }
            sb.append('.');
            if (yiid != null) {
                sb.append(" Data: ");
                if (node != null) {
                    sb.append(node.getValue());
                } else {
                    sb.append("null");
                }
            }
            sb.append(" Stack:").append(this.tracingBroker.getStackSummary());
            AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
            synchronized (abstractTracingWriteTransaction) {
                this.logs.add(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void logOps() {
        AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
        synchronized (abstractTracingWriteTransaction) {
            if (TracingBroker.LOG.isWarnEnabled()) {
                TracingBroker.LOG.warn("Transaction {} contains the following operations:", this.getIdentifier());
                this.logs.forEach(arg_0 -> ((Logger)TracingBroker.LOG).warn(arg_0));
            }
            this.logs.clear();
        }
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier yiid, NormalizedNode<?, ?> node) {
        this.recordOp(store, yiid, "put", node);
        this.delegate.put(store, yiid, node);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier yiid, NormalizedNode<?, ?> node) {
        this.recordOp(store, yiid, "merge", node);
        this.delegate.merge(store, yiid, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        AbstractTracingWriteTransaction abstractTracingWriteTransaction = this;
        synchronized (abstractTracingWriteTransaction) {
            this.logs.clear();
        }
        return this.delegate.cancel();
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        this.recordOp(store, yiid, "delete", null);
        this.delegate.delete(store, yiid);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        this.recordOp(null, null, "commit", null);
        this.logOps();
        return this.delegate.commit();
    }

    public Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final boolean equals(Object object) {
        return object == this || this.delegate.equals(object);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "; delegate=" + this.delegate;
    }
}

