/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.dom.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.md.sal.trace.api.TracingDOMDataBroker;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTracked;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistry;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistryReportEntry;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingReadOnlyTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingReadWriteTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingTransactionChain;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingWriteTransaction;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingBroker
implements TracingDOMDataBroker {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    static final Logger LOG = LoggerFactory.getLogger(TracingBroker.class);
    private static final int STACK_TRACE_FIRST_RELEVANT_FRAME = 2;
    private final String type;
    private final BindingNormalizedNodeSerializer codec;
    private final DOMDataBroker delegate;
    private final List<Watch> registrationWatches = new ArrayList<Watch>();
    private final List<Watch> writeWatches = new ArrayList<Watch>();
    private final boolean isDebugging;
    private final CloseTrackedRegistry<TracingTransactionChain> transactionChainsRegistry;
    private final CloseTrackedRegistry<TracingReadOnlyTransaction> readOnlyTransactionsRegistry;
    private final CloseTrackedRegistry<TracingWriteTransaction> writeTransactionsRegistry;
    private final CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry;

    public TracingBroker(String type, DOMDataBroker delegate, Config config, BindingNormalizedNodeSerializer codec) {
        this.type = Objects.requireNonNull(type, "type");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.codec = Objects.requireNonNull(codec, "codec");
        this.configure(config);
        this.isDebugging = config.isTransactionDebugContextEnabled() != null ? config.isTransactionDebugContextEnabled() : false;
        String db = "DataBroker";
        this.transactionChainsRegistry = new CloseTrackedRegistry("DataBroker", "createTransactionChain()", this.isDebugging);
        this.readOnlyTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newReadOnlyTransaction()", this.isDebugging);
        this.writeTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newWriteOnlyTransaction()", this.isDebugging);
        this.readWriteTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newReadWriteTransaction()", this.isDebugging);
    }

    private void configure(Config config) {
        this.registrationWatches.clear();
        List paths = config.getRegistrationWatches();
        if (paths != null) {
            for (String path : paths) {
                this.watchRegistrations(path, null);
            }
        }
        this.writeWatches.clear();
        paths = config.getWriteWatches();
        if (paths != null) {
            for (String path : paths) {
                this.watchWrites(path, null);
            }
        }
    }

    public void watchRegistrations(String iidString, LogicalDatastoreType store) {
        LOG.info("Watching registrations to {} in {}", (Object)iidString, (Object)store);
        this.registrationWatches.add(new Watch(iidString, store));
    }

    public void watchWrites(String iidString, LogicalDatastoreType store) {
        LOG.info("Watching writes to {} in {}", (Object)iidString, (Object)store);
        Watch watch = new Watch(iidString, store);
        this.writeWatches.add(watch);
    }

    private boolean isRegistrationWatched(YangInstanceIdentifier iid, LogicalDatastoreType store) {
        if (this.registrationWatches.isEmpty()) {
            return true;
        }
        for (Watch regInterest : this.registrationWatches) {
            if (!regInterest.subtreesOverlap(iid, store)) continue;
            return true;
        }
        return false;
    }

    boolean isWriteWatched(YangInstanceIdentifier iid, LogicalDatastoreType store) {
        if (this.writeWatches.isEmpty()) {
            return true;
        }
        for (Watch watch : this.writeWatches) {
            if (!watch.eventIsOfInterest(iid, store)) continue;
            return true;
        }
        return false;
    }

    static void toPathString(InstanceIdentifier<? extends DataObject> iid, StringBuilder builder) {
        for (InstanceIdentifier.PathArgument pathArg : iid.getPathArguments()) {
            builder.append('/').append(pathArg.getType().getSimpleName());
        }
    }

    String toPathString(YangInstanceIdentifier yiid) {
        StringBuilder sb = new StringBuilder();
        this.toPathString(yiid, sb);
        return sb.toString();
    }

    private void toPathString(YangInstanceIdentifier yiid, StringBuilder sb) {
        InstanceIdentifier iid = this.codec.fromYangInstanceIdentifier(yiid);
        if (null == iid) {
            this.reconstructIidPathString(yiid, sb);
        } else {
            TracingBroker.toPathString((InstanceIdentifier<? extends DataObject>)iid, sb);
        }
    }

    private void reconstructIidPathString(YangInstanceIdentifier yiid, StringBuilder sb) {
        sb.append("<RECONSTRUCTED FROM: \"").append(yiid.toString()).append("\">");
        for (YangInstanceIdentifier.PathArgument pathArg : yiid.getPathArguments()) {
            if (pathArg instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                sb.append('/').append("AUGMENTATION");
                continue;
            }
            sb.append('/').append(pathArg.getNodeType().getLocalName());
        }
    }

    String getStackSummary() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < stack.length; ++i) {
            StackTraceElement frame = stack[i];
            sb.append("\n\t(TracingBroker)\t").append(frame.getClassName()).append('.').append(frame.getMethodName());
        }
        return sb.toString();
    }

    public DOMDataReadWriteTransaction newReadWriteTransaction() {
        return new TracingReadWriteTransaction(this.delegate.newReadWriteTransaction(), this, this.readWriteTransactionsRegistry);
    }

    public DOMDataWriteTransaction newWriteOnlyTransaction() {
        return new TracingWriteTransaction(this.delegate.newWriteOnlyTransaction(), this, this.writeTransactionsRegistry);
    }

    public DOMTransactionChain createTransactionChain(TransactionChainListener transactionChainListener) {
        return new TracingTransactionChain(this.delegate.createTransactionChain(transactionChainListener), this, this.transactionChainsRegistry);
    }

    public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        return new TracingReadOnlyTransaction(this.delegate.newReadOnlyTransaction(), this.readOnlyTransactionsRegistry);
    }

    public Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> getSupportedExtensions() {
        HashMap<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> res = this.delegate.getSupportedExtensions();
        final DOMDataTreeChangeService treeChangeSvc = (DOMDataTreeChangeService)res.get(DOMDataTreeChangeService.class);
        if (treeChangeSvc == null) {
            return res;
        }
        res = new HashMap<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension>(res);
        res.put((Class<? extends DOMDataBrokerExtension>)DOMDataTreeChangeService.class, (DOMDataBrokerExtension)new DOMDataTreeChangeService(){

            public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier domDataTreeIdentifier, L listener) {
                if (TracingBroker.this.isRegistrationWatched(domDataTreeIdentifier.getRootIdentifier(), domDataTreeIdentifier.getDatastoreType())) {
                    LOG.warn("{} registration (registerDataTreeChangeListener) for {} from {}.", new Object[]{listener instanceof ClusteredDOMDataTreeChangeListener ? "Clustered" : "Non-clustered", TracingBroker.this.toPathString(domDataTreeIdentifier.getRootIdentifier()), TracingBroker.this.getStackSummary()});
                }
                return treeChangeSvc.registerDataTreeChangeListener(domDataTreeIdentifier, listener);
            }
        });
        return res;
    }

    public boolean printOpenTransactions(PrintStream ps, int minOpenTXs) {
        if (this.transactionChainsRegistry.getAllUnique().isEmpty() && this.readOnlyTransactionsRegistry.getAllUnique().isEmpty() && this.writeTransactionsRegistry.getAllUnique().isEmpty() && this.readWriteTransactionsRegistry.getAllUnique().isEmpty()) {
            ps.println(this.type + ": No open transactions, great!");
            return false;
        }
        ps.println(this.type + ": " + this.getClass().getSimpleName() + " found some not yet (or never..) closed transaction[chain]s!");
        ps.println("[NB: If no stack traces are shown below, then enable transaction-debug-context-enabled in mdsaltrace_config.xml]");
        ps.println();
        boolean hasFound = this.print(this.readOnlyTransactionsRegistry, ps, "  ", minOpenTXs);
        hasFound |= this.print(this.writeTransactionsRegistry, ps, "  ", minOpenTXs);
        hasFound |= this.print(this.readWriteTransactionsRegistry, ps, "  ", minOpenTXs);
        Set<CloseTrackedRegistryReportEntry<TracingTransactionChain>> entries = this.transactionChainsRegistry.getAllUnique();
        if (!entries.isEmpty()) {
            ps.println("  " + this.transactionChainsRegistry.getAnchor() + " : " + this.transactionChainsRegistry.getCreateDescription());
        }
        for (CloseTrackedRegistryReportEntry<TracingTransactionChain> entry : entries) {
            ps.println("    " + entry.getNumberAddedNotRemoved() + "x TransactionChains opened but not closed here:");
            this.printStackTraceElements(ps, "      ", entry.getStackTraceElements());
            TracingTransactionChain txChain = (TracingTransactionChain)entry.getExampleCloseTracked().getRealCloseTracked();
            hasFound |= this.print(txChain.getReadOnlyTransactionsRegistry(), ps, "        ", minOpenTXs);
            hasFound |= this.print(txChain.getWriteTransactionsRegistry(), ps, "        ", minOpenTXs);
            hasFound |= this.print(txChain.getReadWriteTransactionsRegistry(), ps, "        ", minOpenTXs);
        }
        ps.println();
        return hasFound;
    }

    private <T extends CloseTracked<T>> boolean print(CloseTrackedRegistry<T> registry, PrintStream ps, String indent, int minOpenTransactions) {
        Set<CloseTrackedRegistryReportEntry<T>> unsorted = registry.getAllUnique();
        if (unsorted.size() < minOpenTransactions) {
            return false;
        }
        ArrayList<CloseTrackedRegistryReportEntry<CloseTrackedRegistryReportEntry>> entries = new ArrayList<CloseTrackedRegistryReportEntry<CloseTrackedRegistryReportEntry>>(unsorted);
        entries.sort((o1, o2) -> Long.compare(o2.getNumberAddedNotRemoved(), o1.getNumberAddedNotRemoved()));
        if (!entries.isEmpty()) {
            ps.println(indent + registry.getAnchor() + " : " + registry.getCreateDescription());
        }
        entries.forEach(entry -> {
            ps.println(indent + "  " + entry.getNumberAddedNotRemoved() + "x transactions opened here, which are not closed:");
            this.printStackTraceElements(ps, indent + "    ", entry.getStackTraceElements());
        });
        if (!entries.isEmpty()) {
            ps.println();
        }
        return true;
    }

    private void printStackTraceElements(PrintStream ps, String indent, List<StackTraceElement> stackTraceElements) {
        boolean ellipsis = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (this.isStackTraceElementInteresting(stackTraceElement)) {
                ps.println(indent + stackTraceElement);
                ellipsis = false;
                continue;
            }
            if (ellipsis) continue;
            ps.println(indent + "(...)");
            ellipsis = true;
        }
    }

    private boolean isStackTraceElementInteresting(StackTraceElement element) {
        String className = element.getClassName();
        return !className.startsWith(this.getClass().getPackage().getName()) && !className.startsWith(CloseTracked.class.getPackage().getName()) && !className.startsWith("Proxy") && !className.startsWith("akka") && !className.startsWith("scala") && !className.startsWith("sun.reflect") && !className.startsWith("java.lang.reflect") && !className.startsWith("org.apache.aries.blueprint") && !className.startsWith("org.osgi.util.tracker");
    }

    private class Watch {
        final String iidString;
        final LogicalDatastoreType store;

        Watch(String iidString, LogicalDatastoreType storeOrNull) {
            this.store = storeOrNull;
            this.iidString = iidString;
        }

        private String toIidCompString(YangInstanceIdentifier iid) {
            StringBuilder builder = new StringBuilder();
            TracingBroker.this.toPathString(iid, builder);
            builder.append('/');
            return builder.toString();
        }

        private boolean isParent(String parent, String child) {
            int parentOffset = 0;
            if (parent.length() > 0 && parent.charAt(0) == '<') {
                parentOffset = parent.indexOf(62) + 1;
            }
            int childOffset = 0;
            if (child.length() > 0 && child.charAt(0) == '<') {
                childOffset = child.indexOf(62) + 1;
            }
            return child.startsWith(parent.substring(parentOffset), childOffset);
        }

        public boolean subtreesOverlap(YangInstanceIdentifier iid, LogicalDatastoreType store) {
            if (this.store != null && !this.store.equals((Object)store)) {
                return false;
            }
            String otherIidString = this.toIidCompString(iid);
            return this.isParent(this.iidString, otherIidString) || this.isParent(otherIidString, this.iidString);
        }

        public boolean eventIsOfInterest(YangInstanceIdentifier iid, LogicalDatastoreType store) {
            if (this.store != null && !this.store.equals((Object)store)) {
                return false;
            }
            return this.isParent(this.iidString, TracingBroker.this.toPathString(iid));
        }
    }
}

