/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.dom.impl;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTracked;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedRegistry;
import org.opendaylight.controller.md.sal.trace.closetracker.impl.CloseTrackedTrait;
import org.opendaylight.controller.md.sal.trace.dom.impl.AbstractTracingWriteTransaction;
import org.opendaylight.controller.md.sal.trace.dom.impl.TracingBroker;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class TracingReadWriteTransaction
extends AbstractTracingWriteTransaction
implements DOMDataReadWriteTransaction,
CloseTracked<TracingReadWriteTransaction> {
    private final CloseTrackedTrait<TracingReadWriteTransaction> closeTracker;
    private final DOMDataReadWriteTransaction delegate;

    TracingReadWriteTransaction(DOMDataReadWriteTransaction delegate, TracingBroker tracingBroker, CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry) {
        super((DOMDataWriteTransaction)delegate, tracingBroker);
        this.closeTracker = new CloseTrackedTrait<TracingReadWriteTransaction>(readWriteTransactionsRegistry, this);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        return this.delegate.read(store, yiid);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier yiid) {
        return this.delegate.exists(store, yiid);
    }

    @Override
    public FluentFuture<? extends CommitInfo> commit() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.commit();
    }

    @Override
    public boolean cancel() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.cancel();
    }

    @Override
    public StackTraceElement[] getAllocationContextStackTrace() {
        return this.closeTracker.getAllocationContextStackTrace();
    }

    @Override
    public CloseTracked<TracingReadWriteTransaction> getRealCloseTracked() {
        return this;
    }
}

