/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.aries.jpa.supplier.EmSupplier;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMSupplierImpl
implements EmSupplier {
    private static final long DEFAULT_SHUTDOWN_WAIT_SECS = 10L;
    private static final Logger LOG = LoggerFactory.getLogger(EMSupplierImpl.class);
    private EntityManagerFactory emf;
    private AtomicBoolean shutdown;
    private long shutdownWaitTime = 10L;
    private TimeUnit shutdownWaitTimeUnit = TimeUnit.SECONDS;
    private Set<EntityManager> emSet;
    private CountDownLatch emsToShutDown;
    private Coordinator coordinator;
    private String unitName;

    public EMSupplierImpl(String unitName, EntityManagerFactory emf, Coordinator coordinator) {
        this.unitName = unitName;
        this.emf = emf;
        this.coordinator = coordinator;
        this.shutdown = new AtomicBoolean(false);
        this.emSet = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private EntityManager createEm(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        this.emSet.add(em);
        return em;
    }

    public EntityManager get() {
        Coordination coordination = this.getTopCoordination();
        if (coordination == null) {
            throw new IllegalStateException("Need active coordination");
        }
        EntityManager em = this.getEm(coordination);
        if (em == null) {
            LOG.debug("Creating EntityManager for persistence unit " + this.unitName + ", coordination " + coordination.getName());
            em = this.createEm(this.emf);
            this.emSet.add(em);
            this.setEm(coordination, em);
            coordination.addParticipant((Participant)new EmShutDownParticipant());
        }
        return em;
    }

    Coordination getTopCoordination() {
        Coordination coordination;
        for (coordination = this.coordinator.peek(); coordination != null && coordination.getEnclosingCoordination() != null; coordination = coordination.getEnclosingCoordination()) {
        }
        return coordination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEm(Coordination coordination, EntityManager em) {
        Map vars;
        Map map = vars = coordination.getVariables();
        synchronized (map) {
            Map<String, EntityManager> emMap = this.getEmMap(coordination);
            emMap.put(this.unitName, em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager getEm(Coordination coordination) {
        Map vars;
        Map map = vars = coordination.getVariables();
        synchronized (map) {
            return this.getEmMap(coordination).get(this.unitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager removeEm(Coordination coordination) {
        Map vars;
        Map map = vars = coordination.getVariables();
        synchronized (map) {
            return this.getEmMap(coordination).remove(this.unitName);
        }
    }

    private Map<String, EntityManager> getEmMap(Coordination coordination) {
        HashMap emMap = (HashMap)coordination.getVariables().get(EntityManager.class);
        if (emMap == null) {
            emMap = new HashMap();
            coordination.getVariables().put(EntityManager.class, emMap);
        }
        return emMap;
    }

    public void preCall() {
    }

    public void postCall() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        EMSupplierImpl eMSupplierImpl = this;
        synchronized (eMSupplierImpl) {
            this.shutdown.set(true);
            this.emsToShutDown = new CountDownLatch(this.emSet.size());
        }
        try {
            this.emsToShutDown.await(this.shutdownWaitTime, this.shutdownWaitTimeUnit);
        }
        catch (InterruptedException e) {
            LOG.debug("Close was interrupted", (Throwable)e);
        }
        return this.shutdownRemaining();
    }

    private synchronized boolean shutdownRemaining() {
        boolean clean = this.emSet.isEmpty();
        if (!clean) {
            LOG.warn("{} EntityManagers still open after timeout. Shutting them down now", (Object)this.emSet.size());
        }
        for (EntityManager em : this.emSet) {
            EMSupplierImpl.closeEm(em);
        }
        this.emSet.clear();
        return clean;
    }

    private static void closeEm(EntityManager em) {
        try {
            if (em.isOpen()) {
                em.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Error closing EntityManager", (Throwable)e);
        }
    }

    public void setShutdownWait(long shutdownWaitTime, TimeUnit shutdownWaitTimeUnit) {
        this.shutdownWaitTime = shutdownWaitTime;
        this.shutdownWaitTimeUnit = shutdownWaitTimeUnit;
    }

    private final class EmShutDownParticipant
    implements Participant {
        private EmShutDownParticipant() {
        }

        public void failed(Coordination coordination) throws Exception {
            LOG.debug("Coordination failed " + coordination.getName(), coordination.getFailure());
            this.ended(coordination);
        }

        public void ended(Coordination coordination) throws Exception {
            LOG.debug("Closing EntityManager for persistence unit " + EMSupplierImpl.this.unitName + " as coordination " + coordination.getName() + " ended.");
            EntityManager em = EMSupplierImpl.this.removeEm(coordination);
            EMSupplierImpl.this.emSet.remove(em);
            em.close();
            if (EMSupplierImpl.this.shutdown.get()) {
                EMSupplierImpl.this.emsToShutDown.countDown();
            }
        }
    }
}

