/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.impl;

import javax.persistence.EntityManager;
import org.apache.aries.jpa.supplier.EmSupplier;
import org.apache.aries.jpa.support.impl.AbstractJpaTemplate;
import org.apache.aries.jpa.template.EmFunction;
import org.apache.aries.jpa.template.TransactionType;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLocalJpaTemplate
extends AbstractJpaTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLocalJpaTemplate.class);
    private EmSupplier emSupplier;
    private Coordinator coordinator;

    public ResourceLocalJpaTemplate(EmSupplier emSupplier, Coordinator coordinator) {
        this.emSupplier = emSupplier;
        this.coordinator = coordinator;
    }

    public <R> R txExpr(TransactionType type, EmFunction<R> code) {
        EntityManager em = null;
        boolean weControlTx = false;
        if (type != TransactionType.Required) {
            throw new IllegalStateException("Only transation propagation type REQUIRED is supported");
        }
        Coordination coord = this.coordinator.begin(this.getClass().getName(), 0L);
        try {
            em = this.emSupplier.get();
            boolean bl = weControlTx = !em.getTransaction().isActive();
            if (weControlTx) {
                em.getTransaction().begin();
            }
            Object result = code.apply(em);
            if (weControlTx) {
                em.getTransaction().commit();
            }
            Object object = result;
            return (R)object;
        }
        catch (Exception e) {
            if (weControlTx) {
                ResourceLocalJpaTemplate.safeRollback(em);
            }
            throw this.wrapThrowable(e, "Exception occured in transactional code");
        }
        finally {
            coord.end();
        }
    }

    private static void safeRollback(EntityManager em) {
        if (em != null) {
            try {
                em.getTransaction().rollback();
            }
            catch (Exception e) {
                LOGGER.warn("Exception during transaction rollback", (Throwable)e);
            }
        }
    }
}

