/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.osgi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.aries.jpa.supplier.EmSupplier;
import org.apache.aries.jpa.support.impl.EMSupplierImpl;
import org.apache.aries.jpa.support.impl.ResourceLocalJpaTemplate;
import org.apache.aries.jpa.support.osgi.impl.EmProxy;
import org.apache.aries.jpa.support.osgi.impl.TMTracker;
import org.apache.aries.jpa.template.JpaTemplate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFTracker
extends ServiceTracker {
    private static final Logger LOG = LoggerFactory.getLogger(EMFTracker.class);
    private Coordinator coordinator;

    public EMFTracker(BundleContext context, Coordinator coordinator) {
        super(context, EntityManagerFactory.class, null);
        this.coordinator = coordinator;
    }

    public Object addingService(ServiceReference reference) {
        String unitName = (String)reference.getProperty("osgi.unit.name");
        if (unitName == null) {
            return null;
        }
        BundleContext puContext = reference.getBundle().getBundleContext();
        TrackedEmf tracked = new TrackedEmf();
        tracked.emf = (EntityManagerFactory)puContext.getService(reference);
        tracked.emSupplier = new EMSupplierImpl(unitName, tracked.emf, this.coordinator);
        tracked.emSupplierReg = puContext.registerService(EmSupplier.class, (Object)tracked.emSupplier, EMFTracker.getEmSupplierProps(unitName));
        EntityManager emProxy = EMFTracker.createProxy(tracked.emSupplier);
        tracked.emProxyReg = puContext.registerService(EntityManager.class, (Object)emProxy, EMFTracker.getEmSupplierProps(unitName));
        if (this.getTransactionType(tracked.emf) == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            ResourceLocalJpaTemplate txManager = new ResourceLocalJpaTemplate(tracked.emSupplier, this.coordinator);
            tracked.rlTxManagerReg = puContext.registerService(JpaTemplate.class, (Object)txManager, EMFTracker.rlTxManProps(unitName));
        } else {
            tracked.tmTracker = new TMTracker(puContext, tracked.emSupplier, unitName, this.coordinator);
            tracked.tmTracker.open();
        }
        return tracked;
    }

    private PersistenceUnitTransactionType getTransactionType(EntityManagerFactory emf) {
        try {
            PersistenceUnitTransactionType transactionType = (PersistenceUnitTransactionType)emf.getProperties().get(PersistenceUnitTransactionType.class.getName());
            if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                return PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }
        }
        catch (Exception e) {
            LOG.warn("Error while determining the transaction type. Falling back to JTA.", (Throwable)e);
        }
        return PersistenceUnitTransactionType.JTA;
    }

    private static Dictionary<String, String> getEmSupplierProps(String unitName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", unitName);
        return props;
    }

    private static Dictionary<String, String> rlTxManProps(String unitName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", unitName);
        ((Dictionary)props).put("transaction.type", "RESOURCE_LOCAL");
        return props;
    }

    public void removedService(ServiceReference reference, Object trackedO) {
        TrackedEmf tracked = (TrackedEmf)trackedO;
        if (tracked.tmTracker != null) {
            tracked.tmTracker.close();
        }
        if (tracked.rlTxManagerReg != null) {
            tracked.rlTxManagerReg.unregister();
        }
        tracked.emSupplierReg.unregister();
        tracked.emProxyReg.unregister();
        tracked.emSupplier.close();
        reference.getBundle().getBundleContext().ungetService(reference);
    }

    public static EntityManager createProxy(EmSupplier emSupplier) {
        ClassLoader loader = EntityManager.class.getClassLoader();
        Class[] ifAr = new Class[]{EntityManager.class};
        return (EntityManager)Proxy.newProxyInstance(loader, ifAr, (InvocationHandler)new EmProxy(emSupplier));
    }

    static class TrackedEmf {
        ServiceRegistration emProxyReg;
        ServiceRegistration emSupplierReg;
        EMSupplierImpl emSupplier;
        ServiceRegistration rlTxManagerReg;
        EntityManagerFactory emf;
        TMTracker tmTracker;

        TrackedEmf() {
        }
    }
}

