/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.api.monitoring.SessionEvent;
import org.opendaylight.netconf.api.monitoring.SessionListener;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.osgi.NetconfOperationRouter;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.netconf.util.messages.SendErrorExceptionUtil;
import org.opendaylight.netconf.util.messages.SubtreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NetconfServerSessionListener
implements NetconfSessionListener<NetconfServerSession> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfServerSessionListener.class);
    private final SessionListener monitoringSessionListener;
    private final NetconfOperationRouter operationRouter;
    private final AutoCloseable onSessionDownCloseable;

    public NetconfServerSessionListener(NetconfOperationRouter operationRouter, NetconfMonitoringService monitoringService, AutoCloseable onSessionDownCloseable) {
        this.operationRouter = operationRouter;
        this.monitoringSessionListener = monitoringService.getSessionListener();
        this.onSessionDownCloseable = onSessionDownCloseable;
    }

    public void onSessionUp(NetconfServerSession netconfNetconfServerSession) {
        this.monitoringSessionListener.onSessionUp((NetconfManagementSession)netconfNetconfServerSession);
    }

    public void onSessionDown(NetconfServerSession netconfNetconfServerSession, Exception cause) {
        LOG.debug("Session {} down, reason: {}", (Object)netconfNetconfServerSession, (Object)cause.getMessage());
        this.onDown(netconfNetconfServerSession);
    }

    public void onDown(NetconfServerSession netconfNetconfServerSession) {
        this.monitoringSessionListener.onSessionDown((NetconfManagementSession)netconfNetconfServerSession);
        try {
            this.operationRouter.close();
        }
        catch (Exception closingEx) {
            LOG.debug("Ignoring exception while closing operationRouter", (Throwable)closingEx);
        }
        try {
            this.onSessionDownCloseable.close();
        }
        catch (Exception ex) {
            LOG.debug("Ignoring exception while closing onSessionDownCloseable", (Throwable)ex);
        }
    }

    public void onSessionTerminated(NetconfServerSession netconfNetconfServerSession, NetconfTerminationReason netconfTerminationReason) {
        LOG.debug("Session {} terminated, reason: {}", (Object)netconfNetconfServerSession, (Object)netconfTerminationReason.getErrorMessage());
        this.onDown(netconfNetconfServerSession);
    }

    public void onMessage(NetconfServerSession session, NetconfMessage netconfMessage) {
        try {
            Preconditions.checkState((this.operationRouter != null ? 1 : 0) != 0, (Object)"Cannot handle message, session up was not yet received");
            NetconfMessage message = this.processDocument(netconfMessage, session);
            LOG.debug("Responding with message {}", (Object)message);
            session.sendMessage(message);
            this.monitoringSessionListener.onSessionEvent(SessionEvent.inRpcSuccess((NetconfManagementSession)session));
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected exception", (Throwable)e);
            session.onIncommingRpcFail();
            this.monitoringSessionListener.onSessionEvent(SessionEvent.inRpcFail((NetconfManagementSession)session));
            throw new IllegalStateException("Unable to process incoming message " + netconfMessage, e);
        }
        catch (DocumentedException e) {
            LOG.trace("Error occurred while processing message", (Throwable)e);
            session.onOutgoingRpcError();
            session.onIncommingRpcFail();
            this.monitoringSessionListener.onSessionEvent(SessionEvent.inRpcFail((NetconfManagementSession)session));
            this.monitoringSessionListener.onSessionEvent(SessionEvent.outRpcError((NetconfManagementSession)session));
            SendErrorExceptionUtil.sendErrorMessage((NetconfSession)session, (DocumentedException)e, (NetconfMessage)netconfMessage);
        }
    }

    public void onNotification(NetconfServerSession session, NetconfNotification notification) {
        this.monitoringSessionListener.onSessionEvent(SessionEvent.notification((NetconfManagementSession)session));
    }

    private NetconfMessage processDocument(NetconfMessage netconfMessage, NetconfServerSession session) throws DocumentedException {
        Document incomingDocument = netconfMessage.getDocument();
        Element rootNode = incomingDocument.getDocumentElement();
        if (rootNode.getLocalName().equals("rpc")) {
            Document responseDocument = XmlUtil.newDocument();
            NetconfServerSessionListener.checkMessageId(rootNode);
            Document rpcReply = this.operationRouter.onNetconfMessage(incomingDocument, session);
            rpcReply = SubtreeFilter.applyRpcSubtreeFilter((Document)incomingDocument, (Document)rpcReply);
            session.onIncommingRpcSuccess();
            responseDocument.appendChild(responseDocument.importNode(rpcReply.getDocumentElement(), true));
            return new NetconfMessage(responseDocument);
        }
        throw new DocumentedException("Unknown tag " + rootNode.getNodeName() + " in message:\n" + netconfMessage, DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.UNKNOWN_ELEMENT, DocumentedException.ErrorSeverity.ERROR, (Map)ImmutableMap.of((Object)"bad-element", (Object)rootNode.getNodeName()));
    }

    private static void checkMessageId(Node rootNode) throws DocumentedException {
        NamedNodeMap attributes = rootNode.getAttributes();
        if (attributes.getNamedItemNS("urn:ietf:params:xml:ns:netconf:base:1.0", "message-id") != null) {
            return;
        }
        if (attributes.getNamedItem("message-id") != null) {
            return;
        }
        throw new DocumentedException("Missing attribute " + rootNode.getNodeName(), DocumentedException.ErrorType.RPC, DocumentedException.ErrorTag.MISSING_ATTRIBUTE, DocumentedException.ErrorSeverity.ERROR, (Map)ImmutableMap.of((Object)"bad-attribute", (Object)"message-id", (Object)"bad-element", (Object)"rpc"));
    }
}

