/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.local.LocalAddress;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfServerSessionPreferences;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.NetconfSessionPreferences;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSessionNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfServerSessionNegotiator
extends AbstractNetconfSessionNegotiator<NetconfServerSessionPreferences, NetconfServerSession, NetconfServerSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfServerSessionNegotiator.class);
    private static final String UNKNOWN = "unknown";

    protected NetconfServerSessionNegotiator(NetconfServerSessionPreferences sessionPreferences, Promise<NetconfServerSession> promise, Channel channel, Timer timer, NetconfServerSessionListener sessionListener, long connectionTimeoutMillis) {
        super((NetconfSessionPreferences)sessionPreferences, promise, channel, timer, (NetconfSessionListener)sessionListener, connectionTimeoutMillis);
    }

    protected void handleMessage(NetconfHelloMessage netconfMessage) throws NetconfDocumentedException {
        NetconfServerSession session = (NetconfServerSession)this.getSessionForHelloMessage(netconfMessage);
        this.replaceHelloMessageInboundHandler(session);
        this.negotiationSuccessful(session);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    protected NetconfServerSession getSession(NetconfServerSessionListener sessionListener, Channel channel, NetconfHelloMessage message) {
        Optional additionalHeader = message.getAdditionalHeader();
        NetconfHelloMessageAdditionalHeader parsedHeader = additionalHeader.isPresent() ? (NetconfHelloMessageAdditionalHeader)additionalHeader.get() : new NetconfHelloMessageAdditionalHeader(UNKNOWN, NetconfServerSessionNegotiator.getHostName(channel.localAddress()).getValue(), NetconfServerSessionNegotiator.getHostName(channel.localAddress()).getKey(), "tcp", "client");
        LOG.debug("Additional header from hello parsed as {} from {}", (Object)parsedHeader, (Object)additionalHeader);
        return new NetconfServerSession(sessionListener, channel, ((NetconfServerSessionPreferences)this.getSessionPreferences()).getSessionId(), parsedHeader);
    }

    protected static Map.Entry<String, String> getHostName(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new AbstractMap.SimpleImmutableEntry<String, String>(Integer.toString(inetSocketAddress.getPort()), inetSocketAddress.getHostString());
        }
        if (socketAddress instanceof LocalAddress) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(UNKNOWN, ((LocalAddress)socketAddress).id());
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(UNKNOWN, UNKNOWN);
    }
}

