/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import org.opendaylight.netconf.api.NetconfServerSessionPreferences;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.api.messages.NetconfHelloMessage;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.netconf.impl.NetconfServerSessionNegotiator;
import org.opendaylight.netconf.impl.SessionIdProvider;
import org.opendaylight.netconf.impl.osgi.NetconfOperationRouterImpl;
import org.opendaylight.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiatorFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;

public class NetconfServerSessionNegotiatorFactory
implements NetconfSessionNegotiatorFactory<NetconfServerSession, NetconfServerSessionListener> {
    public static final Set<String> DEFAULT_BASE_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1", (Object)"urn:ietf:params:netconf:capability:exi:1.0");
    private final Timer timer;
    private final SessionIdProvider idProvider;
    private final NetconfOperationServiceFactory aggregatedOpService;
    private final long connectionTimeoutMillis;
    private final NetconfMonitoringService monitoringService;
    private final Set<String> baseCapabilities;

    public NetconfServerSessionNegotiatorFactory(Timer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService) {
        this(timer, netconfOperationProvider, idProvider, connectionTimeoutMillis, monitoringService, null);
    }

    public NetconfServerSessionNegotiatorFactory(Timer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService, Set<String> baseCapabilities) {
        this.timer = timer;
        this.aggregatedOpService = netconfOperationProvider;
        this.idProvider = idProvider;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.monitoringService = monitoringService;
        this.baseCapabilities = NetconfServerSessionNegotiatorFactory.validateBaseCapabilities(baseCapabilities == null ? DEFAULT_BASE_CAPABILITIES : baseCapabilities);
    }

    private static ImmutableSet<String> validateBaseCapabilities(Set<String> baseCapabilities) {
        Sets.SetView unknownBaseCaps = Sets.difference(baseCapabilities, DEFAULT_BASE_CAPABILITIES);
        Preconditions.checkArgument((boolean)unknownBaseCaps.isEmpty(), (String)"Base capabilities that will be supported by netconf server have to be subset of %s, unknown base capabilities: %s", DEFAULT_BASE_CAPABILITIES, (Object)unknownBaseCaps);
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll(baseCapabilities);
        b.add((Object)"urn:ietf:params:netconf:base:1.0");
        return b.build();
    }

    public NetconfServerSessionNegotiator getSessionNegotiator(NetconfSessionListenerFactory<NetconfServerSessionListener> defunctSessionListenerFactory, Channel channel, Promise<NetconfServerSession> promise) {
        long sessionId = this.idProvider.getNextSessionId();
        NetconfServerSessionPreferences proposal = new NetconfServerSessionPreferences(this.createHelloMessage(sessionId, this.monitoringService), sessionId);
        return new NetconfServerSessionNegotiator(proposal, promise, channel, this.timer, this.getListener(Long.toString(sessionId), channel.parent().localAddress()), this.connectionTimeoutMillis);
    }

    private NetconfServerSessionListener getListener(String netconfSessionIdForReporting, SocketAddress socketAddress) {
        NetconfOperationService service = this.getOperationServiceForAddress(netconfSessionIdForReporting, socketAddress);
        NetconfOperationRouterImpl operationRouter = new NetconfOperationRouterImpl(service, this.monitoringService, netconfSessionIdForReporting);
        return new NetconfServerSessionListener(operationRouter, this.monitoringService, (AutoCloseable)service);
    }

    protected NetconfOperationService getOperationServiceForAddress(String netconfSessionIdForReporting, SocketAddress socketAddress) {
        return this.aggregatedOpService.createService(netconfSessionIdForReporting);
    }

    protected final NetconfOperationServiceFactory getOperationServiceFactory() {
        return this.aggregatedOpService;
    }

    private NetconfHelloMessage createHelloMessage(long sessionId, NetconfMonitoringService capabilityProvider) {
        return NetconfHelloMessage.createServerHello((Set)Sets.union(NetconfServerSessionNegotiatorFactory.transformCapabilities(capabilityProvider.getCapabilities()), this.baseCapabilities), (long)sessionId);
    }

    public static Set<String> transformCapabilities(Capabilities capabilities) {
        return Sets.newHashSet((Iterable)Collections2.transform((Collection)capabilities.getCapability(), Uri::getValue));
    }
}

