/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.mapping.operations;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultCloseSession
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCloseSession.class);
    public static final String CLOSE_SESSION = "close-session";
    private final AutoCloseable sessionResources;
    private NetconfServerSession session;

    public DefaultCloseSession(String netconfSessionIdForReporting, AutoCloseable sessionResources) {
        super(netconfSessionIdForReporting);
        this.sessionResources = sessionResources;
    }

    protected String getOperationName() {
        return CLOSE_SESSION;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        try {
            this.sessionResources.close();
            ((NetconfServerSession)((Object)Preconditions.checkNotNull((Object)((Object)this.session), (Object)"Session was not set"))).delayedClose();
            LOG.info("Session {} closing", (Object)this.session.getSessionId());
        }
        catch (Exception e) {
            throw new DocumentedException("Unable to properly close session " + this.getNetconfSessionIdForReporting(), e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR, Collections.singletonMap(DocumentedException.ErrorSeverity.ERROR.toString(), e.getMessage()));
        }
        return document.createElement("ok");
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.session = netconfServerSession;
    }
}

