/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.mapping.operations;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultStartExi
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    public static final String START_EXI = "start-exi";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStartExi.class);
    private NetconfServerSession netconfSession;

    public DefaultStartExi(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    public Document handle(Document message, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received start-exi message {} ", (Object)XmlUtil.toString((Document)message));
        }
        try {
            this.netconfSession.startExiCommunication(new NetconfMessage(message));
        }
        catch (IllegalArgumentException e) {
            throw new DocumentedException("Failed to parse EXI parameters", (Exception)e, DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR);
        }
        return super.handle(message, subsequentOperation);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) {
        Element getSchemaResult = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "ok");
        LOG.trace("{} operation successful", (Object)START_EXI);
        return getSchemaResult;
    }

    protected String getOperationName() {
        return START_EXI;
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:exi:1.0";
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.netconfSession = netconfServerSession;
    }
}

