/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.osgi;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mapping.api.NetconfOperation;
import org.opendaylight.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.util.CloseableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
NetconfOperationServiceFactoryListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatedNetconfOperationServiceFactory.class);
    private final Set<NetconfOperationServiceFactory> factories = ConcurrentHashMap.newKeySet();
    private final Multimap<NetconfOperationServiceFactory, AutoCloseable> registrations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Set<CapabilityListener> listeners = ConcurrentHashMap.newKeySet();

    public AggregatedNetconfOperationServiceFactory() {
    }

    public AggregatedNetconfOperationServiceFactory(List<NetconfOperationServiceFactory> mappers) {
        mappers.forEach(this::onAddNetconfOperationServiceFactory);
    }

    public synchronized void onAddNetconfOperationServiceFactory(NetconfOperationServiceFactory service) {
        this.factories.add(service);
        for (CapabilityListener listener : this.listeners) {
            AutoCloseable reg = service.registerCapabilityListener(listener);
            this.registrations.put((Object)service, (Object)reg);
        }
    }

    public synchronized void onRemoveNetconfOperationServiceFactory(NetconfOperationServiceFactory service) {
        this.factories.remove(service);
        for (AutoCloseable autoCloseable : this.registrations.get((Object)service)) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                LOG.warn("Unable to close listener registration", (Throwable)e);
            }
        }
        this.registrations.removeAll((Object)service);
    }

    public Set<Capability> getCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        for (NetconfOperationServiceFactory factory : this.factories) {
            capabilities.addAll(factory.getCapabilities());
        }
        return capabilities;
    }

    public synchronized AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        HashMap<NetconfOperationServiceFactory, AutoCloseable> regs = new HashMap<NetconfOperationServiceFactory, AutoCloseable>();
        for (NetconfOperationServiceFactory factory : this.factories) {
            AutoCloseable reg = factory.registerCapabilityListener(listener);
            regs.put(factory, reg);
        }
        this.listeners.add(listener);
        return () -> {
            AggregatedNetconfOperationServiceFactory aggregatedNetconfOperationServiceFactory = this;
            synchronized (aggregatedNetconfOperationServiceFactory) {
                this.listeners.remove(listener);
                CloseableUtil.closeAll(regs.values());
                for (Map.Entry reg : regs.entrySet()) {
                    this.registrations.remove(reg.getKey(), reg.getValue());
                }
            }
        };
    }

    public synchronized NetconfOperationService createService(String netconfSessionIdForReporting) {
        return new AggregatedNetconfOperation(this.factories, netconfSessionIdForReporting);
    }

    @Override
    public synchronized void close() throws Exception {
        this.factories.clear();
        for (AutoCloseable reg : this.registrations.values()) {
            reg.close();
        }
        this.registrations.clear();
        this.listeners.clear();
    }

    private static final class AggregatedNetconfOperation
    implements NetconfOperationService {
        private final Set<NetconfOperationService> services;

        AggregatedNetconfOperation(Set<NetconfOperationServiceFactory> factories, String netconfSessionIdForReporting) {
            ImmutableSet.Builder b = ImmutableSet.builder();
            for (NetconfOperationServiceFactory factory : factories) {
                b.add((Object)factory.createService(netconfSessionIdForReporting));
            }
            this.services = b.build();
        }

        public Set<NetconfOperation> getNetconfOperations() {
            HashSet<NetconfOperation> operations = new HashSet<NetconfOperation>();
            for (NetconfOperationService service : this.services) {
                operations.addAll(service.getNetconfOperations());
            }
            return operations;
        }

        public void close() {
            try {
                CloseableUtil.closeAll(this.services);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to properly close all aggregated services", e);
            }
        }
    }
}

