/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.osgi;

import java.util.Optional;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.api.monitoring.SessionListener;
import org.opendaylight.netconf.impl.osgi.NetconfCapabilityMonitoringService;
import org.opendaylight.netconf.impl.osgi.NetconfSessionMonitoringService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;

public class NetconfMonitoringServiceImpl
implements NetconfMonitoringService,
AutoCloseable {
    private final NetconfCapabilityMonitoringService capabilityMonitoring;
    private final NetconfSessionMonitoringService sessionMonitoring;

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider) {
        this(opProvider, Optional.empty(), 0L);
    }

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider, ScheduledThreadPool threadPool, long updateInterval) {
        this(opProvider, Optional.ofNullable(threadPool), updateInterval);
    }

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider, Optional<ScheduledThreadPool> threadPool, long updateInterval) {
        this.capabilityMonitoring = new NetconfCapabilityMonitoringService(opProvider);
        this.sessionMonitoring = new NetconfSessionMonitoringService(threadPool, updateInterval);
    }

    public Sessions getSessions() {
        return this.sessionMonitoring.getSessions();
    }

    public SessionListener getSessionListener() {
        return this.sessionMonitoring;
    }

    public Schemas getSchemas() {
        return this.capabilityMonitoring.getSchemas();
    }

    public String getSchemaForCapability(String moduleName, Optional<String> revision) {
        return this.capabilityMonitoring.getSchemaForModuleRevision(moduleName, revision);
    }

    public Capabilities getCapabilities() {
        return this.capabilityMonitoring.getCapabilities();
    }

    public AutoCloseable registerCapabilitiesListener(NetconfMonitoringService.CapabilitiesListener listener) {
        return this.capabilityMonitoring.registerListener(listener);
    }

    public AutoCloseable registerSessionsListener(NetconfMonitoringService.SessionsListener listener) {
        return this.sessionMonitoring.registerListener(listener);
    }

    public void setNotificationPublisher(BaseNotificationPublisherRegistration notificationPublisher) {
        this.capabilityMonitoring.setNotificationPublisher(notificationPublisher);
    }

    @Override
    public void close() {
        this.capabilityMonitoring.close();
        this.sessionMonitoring.close();
    }
}

