/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum ResponseErrorCode implements Enumeration
{
    ParseError(-32700, "parse-error"),
    InvalidRequest(-32600, "invalid-request"),
    MethodNotFound(-32601, "method-not-found"),
    InvalidParams(-32602, "invalid-params"),
    InternalError(-32603, "internal-error");

    private static final Map<String, ResponseErrorCode> NAME_MAP;
    private static final Map<Integer, ResponseErrorCode> VALUE_MAP;
    private final String name;
    private final int value;

    private ResponseErrorCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<ResponseErrorCode> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static ResponseErrorCode forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (ResponseErrorCode enumItem : ResponseErrorCode.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

