/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ConfiguredEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ConfiguredEndpointsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataConfigEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.DataOperationalEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.NotificationEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpoints;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfiguredEndpointsBuilder
implements Builder<ConfiguredEndpoints> {
    private List<DataConfigEndpoints> _dataConfigEndpoints;
    private List<DataOperationalEndpoints> _dataOperationalEndpoints;
    private List<YangIdentifier> _modules;
    private String _name;
    private List<NotificationEndpoints> _notificationEndpoints;
    private List<RpcEndpoints> _rpcEndpoints;
    private ConfiguredEndpointsKey key;
    Map<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>> augmentation = Collections.emptyMap();

    public ConfiguredEndpointsBuilder() {
    }

    public ConfiguredEndpointsBuilder(Peer arg) {
        this._dataConfigEndpoints = arg.getDataConfigEndpoints();
        this._dataOperationalEndpoints = arg.getDataOperationalEndpoints();
        this._rpcEndpoints = arg.getRpcEndpoints();
        this._notificationEndpoints = arg.getNotificationEndpoints();
        this._name = arg.getName();
        this._modules = arg.getModules();
    }

    public ConfiguredEndpointsBuilder(Entity arg) {
        this._name = arg.getName();
        this._modules = arg.getModules();
    }

    public ConfiguredEndpointsBuilder(ConfiguredEndpoints base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._dataConfigEndpoints = base.getDataConfigEndpoints();
        this._dataOperationalEndpoints = base.getDataOperationalEndpoints();
        this._modules = base.getModules();
        this._notificationEndpoints = base.getNotificationEndpoints();
        this._rpcEndpoints = base.getRpcEndpoints();
        if (base instanceof ConfiguredEndpointsImpl) {
            ConfiguredEndpointsImpl impl = (ConfiguredEndpointsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Peer) {
            this._dataConfigEndpoints = ((Peer)arg).getDataConfigEndpoints();
            this._dataOperationalEndpoints = ((Peer)arg).getDataOperationalEndpoints();
            this._rpcEndpoints = ((Peer)arg).getRpcEndpoints();
            this._notificationEndpoints = ((Peer)arg).getNotificationEndpoints();
            isValidArg = true;
        }
        if (arg instanceof Entity) {
            this._name = ((Entity)arg).getName();
            this._modules = ((Entity)arg).getModules();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer, org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Entity]");
    }

    public ConfiguredEndpointsKey key() {
        return this.key;
    }

    public List<DataConfigEndpoints> getDataConfigEndpoints() {
        return this._dataConfigEndpoints;
    }

    public List<DataOperationalEndpoints> getDataOperationalEndpoints() {
        return this._dataOperationalEndpoints;
    }

    public List<YangIdentifier> getModules() {
        return this._modules;
    }

    public String getName() {
        return this._name;
    }

    public List<NotificationEndpoints> getNotificationEndpoints() {
        return this._notificationEndpoints;
    }

    public List<RpcEndpoints> getRpcEndpoints() {
        return this._rpcEndpoints;
    }

    public <E$$ extends Augmentation<ConfiguredEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ConfiguredEndpointsBuilder withKey(ConfiguredEndpointsKey key) {
        this.key = key;
        return this;
    }

    public ConfiguredEndpointsBuilder setDataConfigEndpoints(List<DataConfigEndpoints> values) {
        this._dataConfigEndpoints = values;
        return this;
    }

    public ConfiguredEndpointsBuilder setDataOperationalEndpoints(List<DataOperationalEndpoints> values) {
        this._dataOperationalEndpoints = values;
        return this;
    }

    public ConfiguredEndpointsBuilder setModules(List<YangIdentifier> values) {
        this._modules = values;
        return this;
    }

    public ConfiguredEndpointsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ConfiguredEndpointsBuilder setNotificationEndpoints(List<NotificationEndpoints> values) {
        this._notificationEndpoints = values;
        return this;
    }

    public ConfiguredEndpointsBuilder setRpcEndpoints(List<RpcEndpoints> values) {
        this._rpcEndpoints = values;
        return this;
    }

    public ConfiguredEndpointsBuilder addAugmentation(Class<? extends Augmentation<ConfiguredEndpoints>> augmentationType, Augmentation<ConfiguredEndpoints> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConfiguredEndpointsBuilder removeAugmentation(Class<? extends Augmentation<ConfiguredEndpoints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ConfiguredEndpoints build() {
        return new ConfiguredEndpointsImpl(this);
    }

    private static final class ConfiguredEndpointsImpl
    implements ConfiguredEndpoints {
        private final List<DataConfigEndpoints> _dataConfigEndpoints;
        private final List<DataOperationalEndpoints> _dataOperationalEndpoints;
        private final List<YangIdentifier> _modules;
        private final String _name;
        private final List<NotificationEndpoints> _notificationEndpoints;
        private final List<RpcEndpoints> _rpcEndpoints;
        private final ConfiguredEndpointsKey key;
        private Map<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfiguredEndpointsImpl(ConfiguredEndpointsBuilder base) {
            this.key = base.key() != null ? base.key() : new ConfiguredEndpointsKey(base.getName());
            this._name = this.key.getName();
            this._dataConfigEndpoints = base.getDataConfigEndpoints();
            this._dataOperationalEndpoints = base.getDataOperationalEndpoints();
            this._modules = base.getModules();
            this._notificationEndpoints = base.getNotificationEndpoints();
            this._rpcEndpoints = base.getRpcEndpoints();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ConfiguredEndpoints> getImplementedInterface() {
            return ConfiguredEndpoints.class;
        }

        @Override
        public ConfiguredEndpointsKey key() {
            return this.key;
        }

        @Override
        public List<DataConfigEndpoints> getDataConfigEndpoints() {
            return this._dataConfigEndpoints;
        }

        @Override
        public List<DataOperationalEndpoints> getDataOperationalEndpoints() {
            return this._dataOperationalEndpoints;
        }

        @Override
        public List<YangIdentifier> getModules() {
            return this._modules;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<NotificationEndpoints> getNotificationEndpoints() {
            return this._notificationEndpoints;
        }

        @Override
        public List<RpcEndpoints> getRpcEndpoints() {
            return this._rpcEndpoints;
        }

        public <E$$ extends Augmentation<ConfiguredEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dataConfigEndpoints);
            result = 31 * result + Objects.hashCode(this._dataOperationalEndpoints);
            result = 31 * result + Objects.hashCode(this._modules);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._notificationEndpoints);
            result = 31 * result + Objects.hashCode(this._rpcEndpoints);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ConfiguredEndpoints.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ConfiguredEndpoints other = (ConfiguredEndpoints)obj;
            if (!Objects.equals(this._dataConfigEndpoints, other.getDataConfigEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._dataOperationalEndpoints, other.getDataOperationalEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._modules, other.getModules())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._notificationEndpoints, other.getNotificationEndpoints())) {
                return false;
            }
            if (!Objects.equals(this._rpcEndpoints, other.getRpcEndpoints())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConfiguredEndpointsImpl otherImpl = (ConfiguredEndpointsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ConfiguredEndpoints>>, Augmentation<ConfiguredEndpoints>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ConfiguredEndpoints");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataConfigEndpoints", this._dataConfigEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataOperationalEndpoints", this._dataOperationalEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_modules", this._modules);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_notificationEndpoints", this._notificationEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rpcEndpoints", this._rpcEndpoints);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

