/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Endpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.peer.RpcEndpointsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RpcEndpointsBuilder
implements Builder<RpcEndpoints> {
    private Uri _endpointUri;
    private String _path;
    private RpcEndpointsKey key;
    Map<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>> augmentation = Collections.emptyMap();

    public RpcEndpointsBuilder() {
    }

    public RpcEndpointsBuilder(Endpoint arg) {
        this._path = arg.getPath();
        this._endpointUri = arg.getEndpointUri();
    }

    public RpcEndpointsBuilder(RpcEndpoints base) {
        Map aug;
        this.key = base.key();
        this._path = base.getPath();
        this._endpointUri = base.getEndpointUri();
        if (base instanceof RpcEndpointsImpl) {
            RpcEndpointsImpl impl = (RpcEndpointsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Endpoint) {
            this._path = ((Endpoint)arg).getPath();
            this._endpointUri = ((Endpoint)arg).getEndpointUri();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Endpoint]");
    }

    public RpcEndpointsKey key() {
        return this.key;
    }

    public Uri getEndpointUri() {
        return this._endpointUri;
    }

    public String getPath() {
        return this._path;
    }

    public <E$$ extends Augmentation<RpcEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RpcEndpointsBuilder withKey(RpcEndpointsKey key) {
        this.key = key;
        return this;
    }

    public RpcEndpointsBuilder setEndpointUri(Uri value) {
        this._endpointUri = value;
        return this;
    }

    public RpcEndpointsBuilder setPath(String value) {
        this._path = value;
        return this;
    }

    public RpcEndpointsBuilder addAugmentation(Class<? extends Augmentation<RpcEndpoints>> augmentationType, Augmentation<RpcEndpoints> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RpcEndpointsBuilder removeAugmentation(Class<? extends Augmentation<RpcEndpoints>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RpcEndpoints build() {
        return new RpcEndpointsImpl(this);
    }

    private static final class RpcEndpointsImpl
    implements RpcEndpoints {
        private final Uri _endpointUri;
        private final String _path;
        private final RpcEndpointsKey key;
        private Map<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RpcEndpointsImpl(RpcEndpointsBuilder base) {
            this.key = base.key() != null ? base.key() : new RpcEndpointsKey(base.getPath());
            this._path = this.key.getPath();
            this._endpointUri = base.getEndpointUri();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<RpcEndpoints> getImplementedInterface() {
            return RpcEndpoints.class;
        }

        @Override
        public RpcEndpointsKey key() {
            return this.key;
        }

        @Override
        public Uri getEndpointUri() {
            return this._endpointUri;
        }

        @Override
        public String getPath() {
            return this._path;
        }

        public <E$$ extends Augmentation<RpcEndpoints>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._endpointUri);
            result = 31 * result + Objects.hashCode(this._path);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RpcEndpoints.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RpcEndpoints other = (RpcEndpoints)obj;
            if (!Objects.equals(this._endpointUri, other.getEndpointUri())) {
                return false;
            }
            if (!Objects.equals(this._path, other.getPath())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RpcEndpointsImpl otherImpl = (RpcEndpointsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RpcEndpoints>>, Augmentation<RpcEndpoints>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RpcEndpoints");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_endpointUri", (Object)this._endpointUri);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_path", (Object)this._path);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

