/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedReadOnlyTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedReadWriteTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;

abstract class AbstractDOMForwardedTransactionFactory<T extends DOMStoreTransactionFactory>
implements AutoCloseable {
    private static final AtomicIntegerFieldUpdater<AbstractDOMForwardedTransactionFactory> UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDOMForwardedTransactionFactory.class, "closed");
    private final Map<LogicalDatastoreType, T> storeTxFactories;
    private volatile int closed = 0;

    protected AbstractDOMForwardedTransactionFactory(Map<LogicalDatastoreType, ? extends T> txFactories) {
        this.storeTxFactories = new EnumMap<LogicalDatastoreType, T>(txFactories);
    }

    protected abstract Object newTransactionIdentifier();

    protected abstract FluentFuture<? extends CommitInfo> commit(DOMDataTreeWriteTransaction var1, Collection<DOMStoreThreePhaseCommitCohort> var2);

    public final DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreReadTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreReadTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newReadOnlyTransaction());
        }
        return new DOMForwardedReadOnlyTransaction(this.newTransactionIdentifier(), (Map<LogicalDatastoreType, DOMStoreReadTransaction>)txns);
    }

    public final DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreWriteTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreWriteTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newWriteOnlyTransaction());
        }
        return new DOMForwardedWriteTransaction(this.newTransactionIdentifier(), txns, this);
    }

    public final DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreReadWriteTransaction> txns = new EnumMap<LogicalDatastoreType, DOMStoreReadWriteTransaction>(LogicalDatastoreType.class);
        for (Map.Entry<LogicalDatastoreType, T> store : this.storeTxFactories.entrySet()) {
            txns.put(store.getKey(), ((DOMStoreTransactionFactory)store.getValue()).newReadWriteTransaction());
        }
        return new DOMForwardedReadWriteTransaction(this.newTransactionIdentifier(), (Map<LogicalDatastoreType, DOMStoreReadWriteTransaction>)txns, (AbstractDOMForwardedTransactionFactory<?>)this);
    }

    protected final Map<LogicalDatastoreType, T> getTxFactories() {
        return this.storeTxFactories;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((this.closed == 0 ? 1 : 0) != 0, (Object)"Transaction factory was closed. No further operations allowed.");
    }

    @Override
    public void close() {
        Preconditions.checkState((boolean)UPDATER.compareAndSet(this, 0, 1), (Object)"Transaction factory was already closed");
    }
}

