/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTableEntry;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Beta
abstract class AbstractDOMRoutingTable<I, D, M, L extends EventListener, E extends AbstractDOMRoutingTableEntry<D, M, L>> {
    private final Map<SchemaPath, E> operations;
    private final SchemaContext schemaContext;

    AbstractDOMRoutingTable(Map<SchemaPath, E> operations, SchemaContext schemaContext) {
        this.operations = Objects.requireNonNull(operations);
        this.schemaContext = schemaContext;
    }

    AbstractDOMRoutingTable<I, D, M, L, E> setSchemaContext(SchemaContext context) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, E> e : this.operations.entrySet()) {
            E entry = this.createOperationEntry(context, e.getKey(), ((AbstractDOMRoutingTableEntry)e.getValue()).getImplementations());
            if (entry == null) continue;
            b.put((Object)e.getKey(), entry);
        }
        return this.newInstance((Map<SchemaPath, E>)b.build(), context);
    }

    AbstractDOMRoutingTable<I, D, M, L, E> add(M implementation, Set<I> oprsToAdd) {
        if (oprsToAdd.isEmpty()) {
            return this;
        }
        ListMultimap<SchemaPath, D> toAdd = this.decomposeIdentifiers(oprsToAdd);
        ImmutableMap.Builder mb = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, E> entry : this.operations.entrySet()) {
            ArrayList newOperations = new ArrayList(toAdd.removeAll((Object)entry.getKey()));
            if (!newOperations.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)entry.getValue()).add(implementation, newOperations);
                mb.put((Object)entry.getKey(), ne);
                continue;
            }
            mb.put(entry);
        }
        for (Map.Entry<Object, Object> entry : toAdd.asMap().entrySet()) {
            ImmutableMap.Builder vb = ImmutableMap.builder();
            ImmutableList v = ImmutableList.of(implementation);
            for (Object i : (Collection)entry.getValue()) {
                vb.put(i, (Object)v);
            }
            E entry2 = this.createOperationEntry(this.schemaContext, (SchemaPath)entry.getKey(), (Map<D, List<M>>)vb.build());
            if (entry2 == null) continue;
            mb.put(entry.getKey(), entry2);
        }
        return this.newInstance((Map<SchemaPath, E>)mb.build(), this.schemaContext);
    }

    AbstractDOMRoutingTable<I, D, M, L, E> remove(M implementation, Set<I> instances) {
        if (instances.isEmpty()) {
            return this;
        }
        ListMultimap<SchemaPath, D> toRemove = this.decomposeIdentifiers(instances);
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<SchemaPath, E> e : this.operations.entrySet()) {
            ArrayList removed = new ArrayList(toRemove.removeAll((Object)e.getKey()));
            if (!removed.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)e.getValue()).remove(implementation, removed);
                if (ne == null) continue;
                b.put((Object)e.getKey(), ne);
                continue;
            }
            b.put(e);
        }
        return this.newInstance((Map<SchemaPath, E>)b.build(), this.schemaContext);
    }

    @VisibleForTesting
    Map<SchemaPath, Set<D>> getOperations() {
        return Maps.transformValues(this.operations, AbstractDOMRoutingTableEntry::registeredIdentifiers);
    }

    Map<SchemaPath, Set<D>> getOperations(L listener) {
        HashMap<SchemaPath, Set<D>> ret = new HashMap<SchemaPath, Set<D>>(this.operations.size());
        for (Map.Entry<SchemaPath, E> e : this.operations.entrySet()) {
            Set ids = ((AbstractDOMRoutingTableEntry)e.getValue()).registeredIdentifiers(listener);
            if (ids.isEmpty()) continue;
            ret.put(e.getKey(), ids);
        }
        return ret;
    }

    @Nullable AbstractDOMRoutingTableEntry<D, M, L> getEntry(@NonNull SchemaPath type) {
        return (AbstractDOMRoutingTableEntry)this.operations.get(type);
    }

    protected abstract AbstractDOMRoutingTable<I, D, M, L, E> newInstance(Map<SchemaPath, E> var1, SchemaContext var2);

    abstract ListMultimap<SchemaPath, D> decomposeIdentifiers(Set<I> var1);

    abstract E createOperationEntry(SchemaContext var1, SchemaPath var2, Map<D, List<M>> var3);
}

