/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.SimpleDOMMountPoint;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMMountPointServiceImpl
implements DOMMountPointService {
    private static final Logger LOG = LoggerFactory.getLogger(DOMMountPointServiceImpl.class);
    private final Map<YangInstanceIdentifier, DOMMountPoint> mountPoints = new HashMap<YangInstanceIdentifier, DOMMountPoint>();
    private final ListenerRegistry<DOMMountPointListener> listeners = ListenerRegistry.create();

    public Optional<DOMMountPoint> getMountPoint(YangInstanceIdentifier path) {
        return Optional.ofNullable(this.mountPoints.get(path));
    }

    public DOMMountPointService.DOMMountPointBuilder createMountPoint(YangInstanceIdentifier path) {
        Preconditions.checkState((!this.mountPoints.containsKey(path) ? 1 : 0) != 0, (Object)"Mount point already exists");
        return new DOMMountPointBuilderImpl(path);
    }

    public ListenerRegistration<DOMMountPointListener> registerProvisionListener(DOMMountPointListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    @Deprecated
    public ObjectRegistration<DOMMountPoint> registerMountPoint(DOMMountPoint mountPoint) {
        Preconditions.checkArgument((boolean)(mountPoint instanceof SimpleDOMMountPoint), (Object)"Expected mountpoint argument to be of type SimpleDOMMountPoint");
        return this.doRegisterMountPoint((SimpleDOMMountPoint)mountPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRegistration<DOMMountPoint> doRegisterMountPoint(SimpleDOMMountPoint mountPoint) {
        YangInstanceIdentifier mountPointId = mountPoint.getIdentifier();
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            DOMMountPoint prev = this.mountPoints.putIfAbsent(mountPointId, (DOMMountPoint)mountPoint);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Mount point %s already exists as %s", (Object)mountPointId, (Object)prev);
        }
        this.listeners.forEach(listener -> {
            try {
                ((DOMMountPointListener)listener.getInstance()).onMountPointCreated(mountPointId);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} created event", new Object[]{listener, mountPoint, ex});
            }
        });
        return new AbstractObjectRegistration<DOMMountPoint>((DOMMountPoint)mountPoint){

            protected void removeRegistration() {
                DOMMountPointServiceImpl.this.doUnregisterMountPoint((YangInstanceIdentifier)((DOMMountPoint)this.getInstance()).getIdentifier());
            }
        };
    }

    @Deprecated
    public void unregisterMountPoint(YangInstanceIdentifier mountPointId) {
        this.doUnregisterMountPoint(mountPointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnregisterMountPoint(YangInstanceIdentifier mountPointId) {
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            if (this.mountPoints.remove(mountPointId) == null) {
                LOG.warn("Removing non-existent mount point {} at", (Object)mountPointId, (Object)new Throwable());
                return;
            }
        }
        this.listeners.forEach(listener -> {
            try {
                ((DOMMountPointListener)listener.getInstance()).onMountPointRemoved(mountPointId);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} removed event", new Object[]{listener, mountPointId, ex});
            }
        });
    }

    final class DOMMountPointBuilderImpl
    implements DOMMountPointService.DOMMountPointBuilder {
        private final MutableClassToInstanceMap<DOMService> services = MutableClassToInstanceMap.create();
        private final YangInstanceIdentifier path;
        private SchemaContext schemaContext;
        private SimpleDOMMountPoint mountPoint;

        DOMMountPointBuilderImpl(YangInstanceIdentifier path) {
            this.path = Objects.requireNonNull(path);
        }

        @VisibleForTesting
        SchemaContext getSchemaContext() {
            return this.schemaContext;
        }

        @VisibleForTesting
        Map<Class<? extends DOMService>, DOMService> getServices() {
            return this.services;
        }

        public <T extends DOMService> DOMMountPointService.DOMMountPointBuilder addService(Class<T> type, T impl) {
            this.services.putInstance(Objects.requireNonNull(type), Objects.requireNonNull(impl));
            return this;
        }

        public DOMMountPointService.DOMMountPointBuilder addInitialSchemaContext(SchemaContext ctx) {
            this.schemaContext = Objects.requireNonNull(ctx);
            return this;
        }

        public ObjectRegistration<DOMMountPoint> register() {
            Preconditions.checkState((this.mountPoint == null ? 1 : 0) != 0, (Object)"Mount point is already built.");
            this.mountPoint = SimpleDOMMountPoint.create((YangInstanceIdentifier)this.path, this.services, (SchemaContext)this.schemaContext);
            return DOMMountPointServiceImpl.this.doRegisterMountPoint(this.mountPoint);
        }
    }
}

