/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMTransactionChainAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMWriteTransactionAdapter;

public class ShardedDOMDataBrokerAdapter
implements DOMDataBroker {
    private final DOMDataTreeService service;
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();

    public ShardedDOMDataBrokerAdapter(DOMDataTreeService service) {
        this.service = service;
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new ShardedDOMReadTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return new ShardedDOMWriteTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new ShardedDOMReadWriteTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        return new ShardedDOMTransactionChainAdapter(this.newChainIdentifier(), this.service, listener);
    }

    private Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    private Object newChainIdentifier() {
        return "DOM-CHAIN-" + this.chainNum;
    }
}

