/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingService;
import org.opendaylight.mdsal.dom.broker.DOMDataTreeShardRegistration;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTreeProducer;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTable;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTableEntry;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeListenerAggregator;
import org.opendaylight.mdsal.dom.spi.shard.ListenableDOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardedDOMDataTree
implements DOMDataTreeService,
DOMDataTreeShardingService {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataTree.class);
    @GuardedBy(value="this")
    private final DOMDataTreePrefixTable<DOMDataTreeShardRegistration<?>> shards = DOMDataTreePrefixTable.create();
    @GuardedBy(value="this")
    private final DOMDataTreePrefixTable<DOMDataTreeProducer> producers = DOMDataTreePrefixTable.create();
    @GuardedBy(value="this")
    private final Map<DOMDataTreeIdentifier, DOMDataTreeProducer> producerMap = new HashMap<DOMDataTreeIdentifier, DOMDataTreeProducer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeShard(DOMDataTreeShardRegistration<?> reg) {
        DOMDataTreeIdentifier prefix = reg.getPrefix();
        DOMDataTreeShard lookupShard = null;
        ShardedDOMDataTree shardedDOMDataTree = this;
        synchronized (shardedDOMDataTree) {
            this.shards.remove(prefix);
            DOMDataTreePrefixTableEntry parentRegEntry = this.shards.lookup(prefix);
            if (parentRegEntry != null) {
                lookupShard = (DOMDataTreeShard)((DOMDataTreeShardRegistration)((Object)parentRegEntry.getValue())).getInstance();
            }
        }
        if (lookupShard != null) {
            lookupShard.onChildDetached(prefix, (DOMDataTreeShard)reg.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DOMDataTreeShard> DOMDataTreeShardRegistration<T> registerDataTreeShard(DOMDataTreeIdentifier prefix, T shard, DOMDataTreeProducer producer) throws DOMDataTreeShardingConflictException {
        DOMDataTreeShardRegistration<T> reg;
        DOMDataTreeShardRegistration parentReg;
        Preconditions.checkArgument((boolean)(producer instanceof ShardedDOMDataTreeProducer), (String)"Unsupported producer %s", (Object)producer);
        ShardedDOMDataTreeProducer prod = (ShardedDOMDataTreeProducer)producer;
        DOMDataTreeIdentifier firstSubtree = (DOMDataTreeIdentifier)Iterables.getOnlyElement(prod.getSubtrees());
        Preconditions.checkArgument((firstSubtree != null ? 1 : 0) != 0, (Object)"Producer that is used to verify namespace claim can only claim a single namespace");
        Preconditions.checkArgument((boolean)prefix.equals((Object)firstSubtree), (Object)"Trying to register shard to a different namespace than the producer has claimed");
        ShardedDOMDataTree shardedDOMDataTree = this;
        synchronized (shardedDOMDataTree) {
            DOMDataTreePrefixTableEntry parent = this.shards.lookup(prefix);
            if (parent != null) {
                parentReg = (DOMDataTreeShardRegistration)((Object)parent.getValue());
                if (parentReg != null && prefix.equals((Object)parentReg.getPrefix())) {
                    throw new DOMDataTreeShardingConflictException(String.format("Prefix %s is already occupied by shard %s", prefix, parentReg.getInstance()));
                }
            } else {
                parentReg = null;
            }
            reg = new DOMDataTreeShardRegistration<T>(this, prefix, shard);
            this.shards.store(prefix, reg);
            prod.subshardAdded(Collections.singletonMap(prefix, shard));
        }
        if (parentReg != null) {
            ((DOMDataTreeShard)parentReg.getInstance()).onChildAttached(prefix, shard);
        }
        return reg;
    }

    @GuardedBy(value="this")
    private DOMDataTreeProducer findProducer(DOMDataTreeIdentifier subtree) {
        DOMDataTreePrefixTableEntry producerEntry = this.producers.lookup(subtree);
        if (producerEntry != null) {
            return (DOMDataTreeProducer)producerEntry.getValue();
        }
        return null;
    }

    synchronized void destroyProducer(ShardedDOMDataTreeProducer producer) {
        for (DOMDataTreeIdentifier s : producer.getSubtrees()) {
            this.producers.remove(s);
            this.producerMap.remove(s);
        }
    }

    public ClassToInstanceMap<DOMDataTreeServiceExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }

    @GuardedBy(value="this")
    private DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees, Map<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap) {
        DOMDataTreeProducer ret = ShardedDOMDataTreeProducer.create(this, subtrees, shardMap);
        for (DOMDataTreeIdentifier subtree : subtrees) {
            this.producers.store(subtree, (Object)ret);
            this.producerMap.put(subtree, ret);
        }
        return ret;
    }

    public synchronized DOMDataTreeProducer createProducer(Collection<DOMDataTreeIdentifier> subtrees) {
        Preconditions.checkArgument((!subtrees.isEmpty() ? 1 : 0) != 0, (Object)"Subtrees may not be empty");
        HashMap<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap = new HashMap<DOMDataTreeIdentifier, DOMDataTreeShard>();
        for (DOMDataTreeIdentifier subtree : subtrees) {
            DOMDataTreeProducer producer = this.findProducer(subtree);
            Preconditions.checkArgument((producer == null ? 1 : 0) != 0, (String)"Subtree %s is attached to producer %s", (Object)subtree, (Object)producer);
            for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeProducer> producerEntry : this.producerMap.entrySet()) {
                Preconditions.checkArgument((!subtree.contains(producerEntry.getKey()) ? 1 : 0) != 0, (String)"Subtree %s contains subtree %s which is already attached to producer %s.", (Object)subtree, (Object)producerEntry.getKey(), (Object)producerEntry.getValue());
            }
            DOMDataTreePrefixTableEntry possibleShardReg = this.shards.lookup(subtree);
            if (possibleShardReg == null || possibleShardReg.getValue() == null) continue;
            shardMap.put(subtree, (DOMDataTreeShard)((DOMDataTreeShardRegistration)((Object)possibleShardReg.getValue())).getInstance());
        }
        return this.createProducer(subtrees, shardMap);
    }

    synchronized DOMDataTreeProducer createProducer(ShardedDOMDataTreeProducer parent, Collection<DOMDataTreeIdentifier> subtrees) {
        Objects.requireNonNull(parent);
        HashMap<DOMDataTreeIdentifier, DOMDataTreeShard> shardMap = new HashMap<DOMDataTreeIdentifier, DOMDataTreeShard>();
        for (DOMDataTreeIdentifier s : subtrees) {
            shardMap.put(s, (DOMDataTreeShard)((DOMDataTreeShardRegistration)((Object)this.shards.lookup(s).getValue())).getInstance());
        }
        return this.createProducer(subtrees, shardMap);
    }

    public synchronized <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(final T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) throws DOMDataTreeLoopException {
        ImmutableSet noDupSubtrees;
        Objects.requireNonNull(listener, "listener");
        switch (subtrees.size()) {
            case 0: {
                throw new IllegalArgumentException("Subtrees must not be empty.");
            }
            case 1: {
                noDupSubtrees = subtrees;
                break;
            }
            default: {
                for (Object toCheck : subtrees) {
                    for (DOMDataTreeIdentifier against : subtrees) {
                        if (toCheck.equals((Object)against)) continue;
                        Preconditions.checkArgument((!toCheck.contains(against) ? 1 : 0) != 0, (String)"Subtree %s contains subtree %s", (Object)toCheck, (Object)against);
                    }
                }
                noDupSubtrees = ImmutableSet.copyOf(subtrees);
            }
        }
        LOG.trace("Requested registration of listener {} to subtrees {}", listener, noDupSubtrees);
        ArrayListMultimap needed = ArrayListMultimap.create();
        for (DOMDataTreeIdentifier subtree : subtrees) {
            DOMDataTreeShardRegistration reg2 = (DOMDataTreeShardRegistration)((Object)Verify.verifyNotNull((Object)this.shards.lookup(subtree).getValue()));
            needed.put((Object)reg2, (Object)subtree);
        }
        LOG.trace("Listener {} is attaching to shards {}", listener, (Object)needed);
        needed.asMap().forEach((reg, trees) -> {
            DOMDataTreeShard shard = (DOMDataTreeShard)reg.getInstance();
            Preconditions.checkArgument((shard instanceof ListenableDOMDataTreeShard || shard instanceof DOMStoreTreeChangePublisher ? 1 : 0) != 0, (String)"Subtrees %s do not point to listenable subtree.", (Object)trees);
        });
        for (DOMDataTreeProducer producer : producers) {
            Preconditions.checkArgument((boolean)(producer instanceof ShardedDOMDataTreeProducer));
            ShardedDOMDataTree.simpleLoopCheck((Collection<DOMDataTreeIdentifier>)subtrees, ((ShardedDOMDataTreeProducer)producer).getSubtrees());
        }
        final ListenerRegistration<?> underlyingRegistration = ShardedDOMDataTree.createRegisteredListener(listener, needed.asMap(), allowRxMerges, producers);
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                ShardedDOMDataTree.this.removeListener(listener);
                underlyingRegistration.close();
            }
        };
    }

    private static ListenerRegistration<?> createRegisteredListener(DOMDataTreeListener userListener, Map<DOMDataTreeShardRegistration<?>, Collection<DOMDataTreeIdentifier>> needed, boolean allowRxMerges, Collection<DOMDataTreeProducer> producers) {
        for (DOMDataTreeProducer producer : producers) {
            ((ShardedDOMDataTreeProducer)producer).bindToListener(userListener);
        }
        return DOMDataTreeListenerAggregator.aggregateIfNeeded((DOMDataTreeListener)userListener, needed, (boolean)allowRxMerges, AbstractObjectRegistration::getInstance);
    }

    private static void simpleLoopCheck(Collection<DOMDataTreeIdentifier> listen, Set<DOMDataTreeIdentifier> writes) throws DOMDataTreeLoopException {
        for (DOMDataTreeIdentifier listenPath : listen) {
            for (DOMDataTreeIdentifier writePath : writes) {
                if (listenPath.contains(writePath)) {
                    throw new DOMDataTreeLoopException(String.format("Listener must not listen on parent (%s), and also writes child (%s)", listenPath, writePath));
                }
                if (!writePath.contains(listenPath)) continue;
                throw new DOMDataTreeLoopException(String.format("Listener must not write parent (%s), and also listen on child (%s)", writePath, listenPath));
            }
        }
    }

    void removeListener(DOMDataTreeListener listener) {
    }
}

