/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.broker.ShardedDOMTransactionChainAdapter;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class TransactionChainReadTransaction
implements DOMDataTreeReadTransaction {
    private final DOMDataTreeReadTransaction delegateReadTx;
    private final FluentFuture<? extends CommitInfo> previousWriteTxFuture;
    private final Object identifier;
    private final ShardedDOMTransactionChainAdapter txChain;

    TransactionChainReadTransaction(Object txIdentifier, DOMDataTreeReadTransaction delegateReadTx, FluentFuture<? extends CommitInfo> previousWriteTxFuture, ShardedDOMTransactionChainAdapter txChain) {
        this.delegateReadTx = delegateReadTx;
        this.previousWriteTxFuture = previousWriteTxFuture;
        this.identifier = txIdentifier;
        this.txChain = txChain;
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(final LogicalDatastoreType store, final YangInstanceIdentifier path) {
        final SettableFuture readResult = SettableFuture.create();
        this.previousWriteTxFuture.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                TransactionChainReadTransaction.this.delegateReadTx.read(store, path).addCallback(new FutureCallback<Optional<NormalizedNode<?, ?>>>(){

                    public void onSuccess(Optional<NormalizedNode<?, ?>> result) {
                        readResult.set(result);
                    }

                    public void onFailure(Throwable throwable) {
                        TransactionChainReadTransaction.this.txChain.transactionFailed((DOMDataTreeTransaction)TransactionChainReadTransaction.this, throwable);
                        readResult.setException(throwable);
                    }
                }, MoreExecutors.directExecutor());
            }

            public void onFailure(Throwable throwable) {
                readResult.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return readResult;
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.read(store, path).transform(Optional::isPresent, MoreExecutors.directExecutor());
    }

    public void close() {
        this.delegateReadTx.close();
        this.txChain.closeReadTransaction();
    }

    public Object getIdentifier() {
        return this.identifier;
    }
}

