/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker.pingpong;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;

final class PingPongTransaction
implements FutureCallback<CommitInfo> {
    private final @NonNull DOMDataTreeReadWriteTransaction delegate;
    private final @NonNull SettableFuture<CommitInfo> future;
    private @Nullable DOMDataTreeReadWriteTransaction frontendTransaction;

    PingPongTransaction(DOMDataTreeReadWriteTransaction delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.future = SettableFuture.create();
    }

    @NonNull DOMDataTreeReadWriteTransaction getTransaction() {
        return this.delegate;
    }

    DOMDataTreeReadWriteTransaction getFrontendTransaction() {
        return this.frontendTransaction;
    }

    @NonNull FluentFuture<CommitInfo> getCommitFuture() {
        return this.future;
    }

    public void onSuccess(CommitInfo result) {
        this.future.set((Object)result);
    }

    public void onFailure(Throwable throwable) {
        this.future.setException(throwable);
    }

    void recordFrontendTransaction(DOMDataTreeReadWriteTransaction tx) {
        if (this.frontendTransaction != null) {
            this.frontendTransaction = tx;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).toString();
    }
}

