/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.impl;

import java.net.URL;
import java.sql.Driver;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.ops4j.pax.jdbc.impl.DriverDataSourceFactory;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.spi.SafeServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDriverObserver
implements BundleObserver<URL> {
    private static Logger log = LoggerFactory.getLogger(JdbcDriverObserver.class);

    public void addingEntries(Bundle bundle, List<URL> entries) {
        log.info("found JDBC driver service in bundle [{} {}]", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        BundleContext bc = bundle.getBundleContext();
        SafeServiceLoader serviceLoader = new SafeServiceLoader((ClassLoader)new BundleClassLoader(bundle));
        List drivers = serviceLoader.load(Driver.class.getName());
        for (Driver driver : drivers) {
            DriverDataSourceFactory dsf = new DriverDataSourceFactory(driver);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("osgi.jdbc.driver.class", driver.getClass().getName());
            bc.registerService(DataSourceFactory.class.getName(), (Object)dsf, props);
        }
    }

    public void removingEntries(Bundle bundle, List<URL> entries) {
        log.info("removing drivers registered on behalf of bundle {} {}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
    }
}

