/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ThreadSafe
final class NetconfSessionPromise<S extends NetconfSession>
extends DefaultPromise<S> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSessionPromise.class);
    private final ReconnectStrategy strategy;
    private InetSocketAddress address;
    private final Bootstrap bootstrap;
    @GuardedBy(value="this")
    private Future<?> pending;

    NetconfSessionPromise(EventExecutor executor, InetSocketAddress address, ReconnectStrategy strategy, Bootstrap bootstrap) {
        super(executor);
        this.strategy = (ReconnectStrategy)Preconditions.checkNotNull((Object)strategy);
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.bootstrap = (Bootstrap)Preconditions.checkNotNull((Object)bootstrap);
    }

    synchronized void connect() {
        try {
            int timeout = this.strategy.getConnectTimeout();
            LOG.debug("Promise {} attempting connect for {}ms", (Object)this, (Object)timeout);
            if (this.address.isUnresolved()) {
                this.address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
            }
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
            ChannelFuture connectFuture = this.bootstrap.connect((SocketAddress)this.address);
            connectFuture.addListener((GenericFutureListener)new BootstrapConnectListener());
            this.pending = connectFuture;
        }
        catch (Exception e) {
            LOG.info("Failed to connect to {}", (Object)this.address, (Object)e);
            this.setFailure(e);
        }
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    public synchronized Promise<S> setSuccess(S result) {
        LOG.debug("Promise {} completed", (Object)this);
        this.strategy.reconnectSuccessful();
        return super.setSuccess(result);
    }

    private class BootstrapConnectListener
    implements ChannelFutureListener {
        private BootstrapConnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture cf) {
            NetconfSessionPromise netconfSessionPromise = NetconfSessionPromise.this;
            synchronized (netconfSessionPromise) {
                LOG.debug("Promise {} connection resolved", (Object)NetconfSessionPromise.this);
                Preconditions.checkState((boolean)NetconfSessionPromise.this.pending.equals(cf));
                if (NetconfSessionPromise.this.isCancelled()) {
                    if (cf.isSuccess()) {
                        LOG.debug("Closing channel for cancelled promise {}", (Object)NetconfSessionPromise.this);
                        cf.channel().close();
                    }
                    return;
                }
                if (cf.isSuccess()) {
                    LOG.debug("Promise {} connection successful", (Object)NetconfSessionPromise.this);
                    return;
                }
                LOG.debug("Attempt to connect to {} failed", (Object)NetconfSessionPromise.this.address, (Object)cf.cause());
                Future<Void> rf = NetconfSessionPromise.this.strategy.scheduleReconnect(cf.cause());
                rf.addListener((GenericFutureListener)new ReconnectingStrategyListener());
                NetconfSessionPromise.this.pending = rf;
            }
        }

        private class ReconnectingStrategyListener
        implements FutureListener<Void> {
            private ReconnectingStrategyListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<Void> sf) {
                NetconfSessionPromise netconfSessionPromise = NetconfSessionPromise.this;
                synchronized (netconfSessionPromise) {
                    Preconditions.checkState((boolean)NetconfSessionPromise.this.pending.equals(sf));
                    if (!NetconfSessionPromise.this.isCancelled()) {
                        if (sf.isSuccess()) {
                            NetconfSessionPromise.this.connect();
                        } else {
                            NetconfSessionPromise.this.setFailure(sf.cause());
                        }
                    }
                }
            }
        }
    }
}

