/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ThreadSafe
public final class TimedReconnectStrategy
implements ReconnectStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TimedReconnectStrategy.class);
    private final EventExecutor executor;
    private final Long deadline;
    private final Long maxAttempts;
    private final Long maxSleep;
    private final double sleepFactor;
    private final int connectTime;
    private final long minSleep;
    @GuardedBy(value="this")
    private long attempts;
    @GuardedBy(value="this")
    private long lastSleep;
    @GuardedBy(value="this")
    private boolean scheduled;

    public TimedReconnectStrategy(EventExecutor executor, int connectTime, long minSleep, double sleepFactor, Long maxSleep, Long maxAttempts, Long deadline) {
        Preconditions.checkArgument((maxSleep == null || minSleep <= maxSleep ? 1 : 0) != 0);
        Preconditions.checkArgument((sleepFactor >= 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((connectTime >= 0 ? 1 : 0) != 0);
        this.executor = (EventExecutor)Preconditions.checkNotNull((Object)executor);
        this.deadline = deadline;
        this.maxAttempts = maxAttempts;
        this.minSleep = minSleep;
        this.maxSleep = maxSleep;
        this.sleepFactor = sleepFactor;
        this.connectTime = connectTime;
    }

    @Override
    public synchronized Future<Void> scheduleReconnect(Throwable cause) {
        LOG.debug("Connection attempt failed", cause);
        Preconditions.checkState((!this.scheduled ? 1 : 0) != 0);
        long now = System.nanoTime();
        if (this.maxAttempts != null && this.attempts >= this.maxAttempts) {
            return this.executor.newFailedFuture(new Throwable("Maximum reconnection attempts reached"));
        }
        if (this.deadline != null && this.deadline <= now) {
            return this.executor.newFailedFuture((Throwable)new TimeoutException("Reconnect deadline reached"));
        }
        this.lastSleep = this.attempts != 0L ? (long)((double)this.lastSleep * this.sleepFactor) : this.minSleep;
        if (this.maxSleep != null && this.lastSleep > this.maxSleep) {
            LOG.debug("Capped sleep time from {} to {}", (Object)this.lastSleep, (Object)this.maxSleep);
            this.lastSleep = this.maxSleep;
        }
        ++this.attempts;
        if (this.deadline != null && this.deadline <= now + TimeUnit.MILLISECONDS.toNanos(this.lastSleep)) {
            return this.executor.newFailedFuture((Throwable)new TimeoutException("Next reconnect would happen after deadline"));
        }
        LOG.debug("Connection attempt {} sleeping for {} milliseconds", (Object)this.attempts, (Object)this.lastSleep);
        if (this.lastSleep == 0L) {
            return this.executor.newSucceededFuture(null);
        }
        this.scheduled = true;
        return this.executor.schedule(() -> {
            TimedReconnectStrategy timedReconnectStrategy = this;
            synchronized (timedReconnectStrategy) {
                Preconditions.checkState((boolean)this.scheduled);
                this.scheduled = false;
            }
            return null;
        }, this.lastSleep, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void reconnectSuccessful() {
        Preconditions.checkState((!this.scheduled ? 1 : 0) != 0);
        this.attempts = 0L;
    }

    @Override
    public int getConnectTimeout() throws TimeoutException {
        int timeout = this.connectTime;
        if (this.deadline != null) {
            long now = System.nanoTime();
            if (now >= this.deadline) {
                throw new TimeoutException("Reconnect deadline already passed");
            }
            long left = TimeUnit.NANOSECONDS.toMillis(this.deadline - now);
            if (left < 1L) {
                throw new TimeoutException("Connect timeout too close to deadline");
            }
            if ((long)timeout > left) {
                timeout = (int)left;
            } else if (timeout == 0) {
                timeout = left <= Integer.MAX_VALUE ? (int)left : Integer.MAX_VALUE;
            }
        }
        return timeout;
    }
}

