/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalSAXDecoder;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalSAXFactory;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXEncoder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class NetconfEXICodec {
    private static final EntityResolver ENTITY_RESOLVER = (publicId, systemId) -> new InputSource();
    private static final LoadingCache<EXIParameters, NetconfEXICodec> CODECS = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<EXIParameters, NetconfEXICodec>(){

        public NetconfEXICodec load(EXIParameters key) {
            return new NetconfEXICodec(key.getFactory());
        }
    });
    private final ThreadLocalSAXFactory exiFactory;

    private NetconfEXICodec(EXIFactory exiFactory) {
        this.exiFactory = new ThreadLocalSAXFactory(Objects.requireNonNull(exiFactory));
    }

    public static NetconfEXICodec forParameters(EXIParameters parameters) {
        return (NetconfEXICodec)CODECS.getUnchecked((Object)parameters);
    }

    ThreadLocalSAXDecoder getReader() throws EXIException {
        ThreadLocalSAXDecoder reader = this.exiFactory.createEXIReader();
        reader.setEntityResolver(ENTITY_RESOLVER);
        return reader;
    }

    SAXEncoder getWriter() throws EXIException {
        return this.exiFactory.createEXIWriter();
    }
}

