/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalSAXDecoder;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NetconfEXIToMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEXIToMessageDecoder.class);
    private static final SAXTransformerFactory FACTORY;
    private final ThreadLocalSAXDecoder reader;
    private final DocumentBuilder documentBuilder;

    private NetconfEXIToMessageDecoder(ThreadLocalSAXDecoder reader) {
        this.reader = Objects.requireNonNull(reader);
        this.documentBuilder = UntrustedXML.newDocumentBuilder();
    }

    public static NetconfEXIToMessageDecoder create(NetconfEXICodec codec) throws EXIException {
        return new NetconfEXIToMessageDecoder(codec.getReader());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IOException, SAXException, TransformerConfigurationException {
        if (!in.isReadable()) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        TransformerHandler handler = FACTORY.newTransformerHandler();
        this.reader.setContentHandler(handler);
        DOMResult domResult = new DOMResult(this.documentBuilder.newDocument());
        handler.setResult(domResult);
        try (ByteBufInputStream is = new ByteBufInputStream(in);){
            this.reader.parse(new InputSource((InputStream)is));
        }
        out.add(new NetconfMessage((Document)domResult.getNode()));
    }

    static {
        TransformerFactory f = SAXTransformerFactory.newInstance();
        if (!f.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new TransformerFactoryConfigurationError(String.format("Factory %s is not a SAXTransformerFactory", f));
        }
        FACTORY = (SAXTransformerFactory)f;
    }
}

