/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalTransformers;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class NetconfMessageToEXIEncoder
extends MessageToByteEncoder<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageToEXIEncoder.class);
    private final NetconfEXICodec codec;

    private NetconfMessageToEXIEncoder(NetconfEXICodec codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public static NetconfMessageToEXIEncoder create(NetconfEXICodec codec) {
        return new NetconfMessageToEXIEncoder(codec);
    }

    protected void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws IOException, TransformerException, EXIException {
        LOG.trace("Sent to encode : {}", (Object)msg);
        try (ByteBufOutputStream os = new ByteBufOutputStream(out);){
            SAXEncoder encoder = this.codec.getWriter();
            encoder.setOutputStream((OutputStream)os);
            Transformer transformer = ThreadLocalTransformers.getDefaultTransformer();
            transformer.transform(new DOMSource(msg.getDocument()), new SAXResult((ContentHandler)encoder));
        }
    }
}

