/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.exi;

import com.google.common.base.Suppliers;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.grammars.GrammarFactory;

public enum EXISchema {
    NONE("none"){

        @Override
        Grammars createGrammar() {
            return GrammarFactory.newInstance().createSchemaLessGrammars();
        }
    }
    ,
    BUILTIN("builtin"){

        @Override
        Grammars createGrammar() {
            try {
                return GrammarFactory.newInstance().createXSDTypesOnlyGrammars();
            }
            catch (EXIException e) {
                throw new IllegalStateException("Failed to create builtin grammar", e);
            }
        }
    }
    ,
    BASE_1_1("base:1.1"){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Grammars createGrammar() {
            ByteSource source = Resources.asByteSource((URL)EXISchema.class.getResource("/rfc6241.xsd"));
            try (InputStream is = source.openStream();){
                Grammars g = GrammarFactory.newInstance().createGrammars(is);
                g.setSchemaId(this.getOption());
                Grammars grammars = g;
                return grammars;
            }
            catch (IOException | EXIException e) {
                throw new IllegalStateException("Failed to create RFC6241 grammar", e);
            }
        }
    };

    private String option;
    private Supplier<Grammars> grammarsSupplier;

    private EXISchema(String option) {
        this.option = Objects.requireNonNull(option);
        this.grammarsSupplier = Suppliers.memoize(this::createGrammar);
    }

    final String getOption() {
        return this.option;
    }

    final Grammars getGrammar() {
        return this.grammarsSupplier.get();
    }

    abstract Grammars createGrammar();

    static @Nullable EXISchema forOption(String id) {
        for (EXISchema s : EXISchema.values()) {
            if (!id.equals(s.getOption())) continue;
            return s;
        }
        return null;
    }
}

