/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerReader;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSshHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSshHandler.class);
    public static final String SUBSYSTEM = "netconf";
    public static final int SSH_DEFAULT_NIO_WORKERS = 8;
    private static final long DEFAULT_TIMEOUT = -1L;
    public static final SshClient DEFAULT_CLIENT;
    private final AuthenticationHandler authenticationHandler;
    private final SshClient sshClient;
    private final AtomicBoolean isDisconnected = new AtomicBoolean();
    private Future<?> negotiationFuture;
    private AsyncSshHandlerReader sshReadAsyncListener;
    private AsyncSshHandlerWriter sshWriteAsyncHandler;
    private ClientChannel channel;
    private ClientSession session;
    private ChannelPromise connectPromise;
    private GenericFutureListener negotiationFutureListener;

    public AsyncSshHandler(AuthenticationHandler authenticationHandler, SshClient sshClient, Future<?> negotiationFuture) {
        this(authenticationHandler, sshClient);
        this.negotiationFuture = negotiationFuture;
    }

    public AsyncSshHandler(AuthenticationHandler authenticationHandler, SshClient sshClient) {
        this.authenticationHandler = (AuthenticationHandler)Preconditions.checkNotNull((Object)authenticationHandler);
        this.sshClient = (SshClient)Preconditions.checkNotNull((Object)sshClient);
    }

    public static AsyncSshHandler createForNetconfSubsystem(AuthenticationHandler authenticationHandler) {
        return new AsyncSshHandler(authenticationHandler, DEFAULT_CLIENT);
    }

    public static AsyncSshHandler createForNetconfSubsystem(AuthenticationHandler authenticationHandler, Future<?> negotiationFuture) {
        return new AsyncSshHandler(authenticationHandler, DEFAULT_CLIENT, negotiationFuture);
    }

    private void startSsh(ChannelHandlerContext ctx, SocketAddress address) throws IOException {
        LOG.debug("Starting SSH to {} on channel: {}", (Object)address, (Object)ctx.channel());
        ConnectFuture sshConnectionFuture = this.sshClient.connect(this.authenticationHandler.getUsername(), address);
        sshConnectionFuture.addListener(future -> {
            if (future.isConnected()) {
                this.handleSshSessionCreated((ConnectFuture)future, ctx);
            } else {
                this.handleSshSetupFailure(ctx, future.getException());
            }
        });
    }

    private synchronized void handleSshSessionCreated(ConnectFuture future, ChannelHandlerContext ctx) {
        try {
            LOG.trace("SSH session created on channel: {}", (Object)ctx.channel());
            this.session = future.getSession();
            AuthFuture authenticateFuture = this.authenticationHandler.authenticate(this.session);
            ClientSession localSession = this.session;
            authenticateFuture.addListener(future1 -> {
                if (future1.isSuccess()) {
                    this.handleSshAuthenticated(localSession, ctx);
                } else {
                    Throwable exception = future1.getException() == null ? new IllegalStateException("Authentication failed") : future1.getException();
                    this.handleSshSetupFailure(ctx, exception);
                }
            });
        }
        catch (IOException e) {
            this.handleSshSetupFailure(ctx, e);
        }
    }

    private synchronized void handleSshAuthenticated(ClientSession newSession, ChannelHandlerContext ctx) {
        try {
            LOG.debug("SSH session authenticated on channel: {}, server version: {}", (Object)ctx.channel(), (Object)newSession.getServerVersion());
            this.channel = newSession.createSubsystemChannel(SUBSYSTEM);
            this.channel.setStreaming(ClientChannel.Streaming.Async);
            this.channel.open().addListener(future -> {
                if (future.isOpened()) {
                    this.handleSshChanelOpened(ctx);
                } else {
                    this.handleSshSetupFailure(ctx, future.getException());
                }
            });
        }
        catch (IOException e) {
            this.handleSshSetupFailure(ctx, e);
        }
    }

    private synchronized void handleSshChanelOpened(ChannelHandlerContext ctx) {
        LOG.trace("SSH subsystem channel opened successfully on channel: {}", (Object)ctx.channel());
        if (this.negotiationFuture == null) {
            this.connectPromise.setSuccess();
        }
        ClientChannel localChannel = this.channel;
        this.sshReadAsyncListener = new AsyncSshHandlerReader(() -> this.disconnect(ctx, ctx.newPromise()), arg_0 -> ((ChannelHandlerContext)ctx).fireChannelRead(arg_0), localChannel.toString(), localChannel.getAsyncOut());
        if (this.channel != null) {
            this.sshWriteAsyncHandler = new AsyncSshHandlerWriter(this.channel.getAsyncIn());
            ctx.fireChannelActive();
        }
    }

    private synchronized void handleSshSetupFailure(ChannelHandlerContext ctx, Throwable error) {
        LOG.warn("Unable to setup SSH connection on channel: {}", (Object)ctx.channel(), (Object)error);
        if (!this.connectPromise.isDone()) {
            this.connectPromise.setFailure(error);
        }
        this.disconnect(ctx, ctx.newPromise());
    }

    public synchronized void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.sshWriteAsyncHandler.write(ctx, msg, promise);
    }

    public synchronized void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        LOG.debug("SSH session connecting on channel {}. promise: {} ", (Object)ctx.channel(), (Object)this.connectPromise);
        this.connectPromise = promise;
        if (this.negotiationFuture != null) {
            this.negotiationFutureListener = future -> {
                if (future.isSuccess()) {
                    promise.setSuccess();
                }
            };
            this.negotiationFuture.addListener(this.negotiationFutureListener);
        }
        this.startSsh(ctx, remoteAddress);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.disconnect(ctx, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.isDisconnected.compareAndSet(false, true)) {
            this.safelyDisconnect(ctx, promise);
        }
    }

    private synchronized void safelyDisconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        LOG.trace("Closing SSH session on channel: {} with connect promise in state: {}", (Object)ctx.channel(), (Object)this.connectPromise);
        if (this.connectPromise.isSuccess()) {
            ctx.fireChannelInactive();
        }
        if (this.sshWriteAsyncHandler != null) {
            this.sshWriteAsyncHandler.close();
        }
        if (this.sshReadAsyncListener != null) {
            this.sshReadAsyncListener.close();
        }
        if (!this.connectPromise.isDone()) {
            this.connectPromise.setFailure((Throwable)new IllegalStateException("Negotiation failed"));
        }
        if (this.negotiationFuture != null) {
            this.negotiationFuture.removeListener(this.negotiationFutureListener);
        }
        if (this.session != null && !this.session.isClosed() && !this.session.isClosing()) {
            this.session.close(false).addListener(future -> {
                AsyncSshHandler asyncSshHandler = this;
                synchronized (asyncSshHandler) {
                    if (!future.isClosed()) {
                        this.session.close(true);
                    }
                    this.session = null;
                }
            });
        }
        try {
            super.disconnect(ctx, ctx.newPromise());
        }
        catch (Exception e) {
            LOG.warn("Unable to cleanup all resources for channel: {}. Ignoring.", (Object)ctx.channel(), (Object)e);
        }
        this.channel = null;
        promise.setSuccess();
        LOG.debug("SSH session closed on channel: {}", (Object)ctx.channel());
    }

    static {
        SshClient c = SshClient.setUpDefaultClient();
        c.getProperties().put("auth-timeout", Long.toString(-1L));
        c.getProperties().put("idle-timeout", Long.toString(-1L));
        c.getProperties().put("rekey-packets-limit", -1);
        c.getProperties().put("rekey-blocks-limit", -1);
        c.getProperties().put("rekey-time-limit", -1);
        c.getProperties().put("rekey-bytes-limit", -1);
        c.setNioWorkers(8);
        c.start();
        DEFAULT_CLIENT = c;
    }
}

