/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeChangeListenerAggregator;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeListenerRegistry;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

@Deprecated
@Beta
public final class CompatDOMDataTreeListenerRegistry
implements DOMDataTreeListenerRegistry {
    private final DOMStoreTreeChangePublisher publisher;

    public CompatDOMDataTreeListenerRegistry(DOMStoreTreeChangePublisher publisher) {
        this.publisher = Objects.requireNonNull(publisher);
    }

    @Override
    public <T extends DOMDataTreeListener> ListenerRegistration<T> registerListener(T listener, Collection<DOMDataTreeIdentifier> subtrees, boolean allowRxMerges) {
        if (subtrees.size() == 1) {
            DOMDataTreeIdentifier treeId = (DOMDataTreeIdentifier)Iterables.getOnlyElement(subtrees);
            final ListenerRegistration<DOMDataTreeChangeListener> reg = this.publisher.registerTreeChangeListener(treeId.getRootIdentifier(), changes -> {
                Optional last = ((DataTreeCandidate)Iterables.getLast((Iterable)changes)).getRootNode().getDataAfter();
                if (last.isPresent()) {
                    listener.onDataTreeChanged(changes, (Map)ImmutableMap.of((Object)treeId, last.get()));
                } else {
                    listener.onDataTreeChanged(changes, (Map)ImmutableMap.of());
                }
            });
            return new AbstractListenerRegistration<T>(listener){

                protected void removeRegistration() {
                    reg.close();
                }
            };
        }
        int size = subtrees.size();
        ArrayList regs = new ArrayList(size);
        DOMDataTreeChangeListenerAggregator aggregator = new DOMDataTreeChangeListenerAggregator(size, allowRxMerges);
        for (DOMDataTreeIdentifier treeId : subtrees) {
            regs.add(this.publisher.registerTreeChangeListener(treeId.getRootIdentifier(), aggregator.createListener(treeId)));
        }
        return aggregator.start(listener, regs);
    }
}

