/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;

@Beta
public abstract class DelegatingWriteCursorStrategy
extends ForwardingObject
implements WriteCursorStrategy {
    protected abstract DOMDataTreeWriteCursor delegate();

    protected DelegatingWriteCursorStrategy childStrategy() {
        return this;
    }

    @Override
    public WriteCursorStrategy enter(YangInstanceIdentifier.PathArgument arg) {
        this.delegate().enter(arg);
        return this.childStrategy();
    }

    @Override
    public void delete(YangInstanceIdentifier.PathArgument arg) {
        this.delegate().delete(arg);
    }

    @Override
    public void merge(YangInstanceIdentifier.PathArgument arg, NormalizedNode<?, ?> data) {
        this.delegate().merge(arg, data);
    }

    @Override
    public void write(YangInstanceIdentifier.PathArgument arg, NormalizedNode<?, ?> data) {
        this.delegate().write(arg, data);
    }

    @Override
    public void mergeToCurrent(NormalizedNodeContainer<?, ?, ?> data) {
        for (NormalizedNode child : data.getValue()) {
            this.delegate().merge(child.getIdentifier(), child);
        }
    }

    @Override
    public void writeToCurrent(NormalizedNodeContainer<?, ?, ?> data) {
        for (NormalizedNode child : data.getValue()) {
            this.delegate().write(child.getIdentifier(), child);
        }
    }

    @Override
    public void exit() {
        this.delegate().exit();
    }
}

