/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SnapshotBackedReadWriteTransaction<T>
extends SnapshotBackedWriteTransaction<T>
implements DOMStoreReadWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotBackedReadWriteTransaction.class);

    SnapshotBackedReadWriteTransaction(T identifier, boolean debug, DataTreeSnapshot snapshot, SnapshotBackedWriteTransaction.TransactionReadyPrototype<T> readyImpl) {
        super(identifier, debug, snapshot, readyImpl);
    }

    @Override
    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(YangInstanceIdentifier path) {
        Optional<NormalizedNode<?, ?>> result;
        LOG.debug("Tx: {} Read: {}", this.getIdentifier(), (Object)path);
        Objects.requireNonNull(path, "Path must not be null.");
        try {
            result = this.readSnapshotNode(path);
        }
        catch (Exception e) {
            LOG.error("Tx: {} Failed Read of {}", new Object[]{this.getIdentifier(), path, e});
            return FluentFutures.immediateFailedFluentFuture((Throwable)new ReadFailedException("Read failed", (Throwable)e, new RpcError[0]));
        }
        if (result == null) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new ReadFailedException("Transaction is closed", new RpcError[0]));
        }
        return FluentFutures.immediateFluentFuture(result);
    }

    @Override
    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        return this.read(path).transform(Optional::isPresent, MoreExecutors.directExecutor());
    }
}

