/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.YangLibraryChange;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class YangLibraryChangeBuilder
implements Builder<YangLibraryChange> {
    private String _moduleSetId;
    Map<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>> augmentation = Collections.emptyMap();

    public YangLibraryChangeBuilder() {
    }

    public YangLibraryChangeBuilder(YangLibraryChange base) {
        Map aug;
        this._moduleSetId = base.getModuleSetId();
        if (base instanceof YangLibraryChangeImpl) {
            YangLibraryChangeImpl impl = (YangLibraryChangeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>>(aug);
        }
    }

    public String getModuleSetId() {
        return this._moduleSetId;
    }

    public <E$$ extends Augmentation<YangLibraryChange>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public YangLibraryChangeBuilder setModuleSetId(String value) {
        this._moduleSetId = value;
        return this;
    }

    public YangLibraryChangeBuilder addAugmentation(Class<? extends Augmentation<YangLibraryChange>> augmentationType, Augmentation<YangLibraryChange> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public YangLibraryChangeBuilder removeAugmentation(Class<? extends Augmentation<YangLibraryChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public YangLibraryChange build() {
        return new YangLibraryChangeImpl(this);
    }

    private static final class YangLibraryChangeImpl
    implements YangLibraryChange {
        private final String _moduleSetId;
        private Map<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        YangLibraryChangeImpl(YangLibraryChangeBuilder base) {
            this._moduleSetId = base.getModuleSetId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<YangLibraryChange> getImplementedInterface() {
            return YangLibraryChange.class;
        }

        @Override
        public String getModuleSetId() {
            return this._moduleSetId;
        }

        public <E$$ extends Augmentation<YangLibraryChange>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._moduleSetId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!YangLibraryChange.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            YangLibraryChange other = (YangLibraryChange)obj;
            if (!Objects.equals(this._moduleSetId, other.getModuleSetId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                YangLibraryChangeImpl otherImpl = (YangLibraryChangeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<YangLibraryChange>>, Augmentation<YangLibraryChange>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"YangLibraryChange");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_moduleSetId", (Object)this._moduleSetId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

