/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.CommonLeafs;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.SchemaLeaf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.Deviation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.module.Submodule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ModuleBuilder
implements Builder<Module> {
    private Module.ConformanceType _conformanceType;
    private List<Deviation> _deviation;
    private List<YangIdentifier> _feature;
    private YangIdentifier _name;
    private Uri _namespace;
    private CommonLeafs.Revision _revision;
    private Uri _schema;
    private List<Submodule> _submodule;
    private ModuleKey key;
    Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = Collections.emptyMap();

    public ModuleBuilder() {
    }

    public ModuleBuilder(SchemaLeaf arg) {
        this._schema = arg.getSchema();
    }

    public ModuleBuilder(CommonLeafs arg) {
        this._name = arg.getName();
        this._revision = arg.getRevision();
    }

    public ModuleBuilder(Module base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._revision = base.getRevision();
        this._conformanceType = base.getConformanceType();
        this._deviation = base.getDeviation();
        this._feature = base.getFeature();
        this._namespace = base.getNamespace();
        this._schema = base.getSchema();
        this._submodule = base.getSubmodule();
        if (base instanceof ModuleImpl) {
            ModuleImpl impl = (ModuleImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonLeafs) {
            this._name = ((CommonLeafs)arg).getName();
            this._revision = ((CommonLeafs)arg).getRevision();
            isValidArg = true;
        }
        if (arg instanceof SchemaLeaf) {
            this._schema = ((SchemaLeaf)arg).getSchema();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.CommonLeafs, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.SchemaLeaf]");
    }

    public ModuleKey key() {
        return this.key;
    }

    public Module.ConformanceType getConformanceType() {
        return this._conformanceType;
    }

    public List<Deviation> getDeviation() {
        return this._deviation;
    }

    public List<YangIdentifier> getFeature() {
        return this._feature;
    }

    public YangIdentifier getName() {
        return this._name;
    }

    public Uri getNamespace() {
        return this._namespace;
    }

    public CommonLeafs.Revision getRevision() {
        return this._revision;
    }

    public Uri getSchema() {
        return this._schema;
    }

    public List<Submodule> getSubmodule() {
        return this._submodule;
    }

    public <E$$ extends Augmentation<Module>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ModuleBuilder withKey(ModuleKey key) {
        this.key = key;
        return this;
    }

    public ModuleBuilder setConformanceType(Module.ConformanceType value) {
        this._conformanceType = value;
        return this;
    }

    public ModuleBuilder setDeviation(List<Deviation> values) {
        this._deviation = values;
        return this;
    }

    public ModuleBuilder setFeature(List<YangIdentifier> values) {
        this._feature = values;
        return this;
    }

    public ModuleBuilder setName(YangIdentifier value) {
        this._name = value;
        return this;
    }

    public ModuleBuilder setNamespace(Uri value) {
        this._namespace = value;
        return this;
    }

    public ModuleBuilder setRevision(CommonLeafs.Revision value) {
        this._revision = value;
        return this;
    }

    public ModuleBuilder setSchema(Uri value) {
        this._schema = value;
        return this;
    }

    public ModuleBuilder setSubmodule(List<Submodule> values) {
        this._submodule = values;
        return this;
    }

    public ModuleBuilder addAugmentation(Class<? extends Augmentation<Module>> augmentationType, Augmentation<Module> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ModuleBuilder removeAugmentation(Class<? extends Augmentation<Module>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl
    implements Module {
        private final Module.ConformanceType _conformanceType;
        private final List<Deviation> _deviation;
        private final List<YangIdentifier> _feature;
        private final YangIdentifier _name;
        private final Uri _namespace;
        private final CommonLeafs.Revision _revision;
        private final Uri _schema;
        private final List<Submodule> _submodule;
        private final ModuleKey key;
        private Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ModuleImpl(ModuleBuilder base) {
            this.key = base.key() != null ? base.key() : new ModuleKey(base.getName(), base.getRevision());
            this._name = this.key.getName();
            this._revision = this.key.getRevision();
            this._conformanceType = base.getConformanceType();
            this._deviation = base.getDeviation();
            this._feature = base.getFeature();
            this._namespace = base.getNamespace();
            this._schema = base.getSchema();
            this._submodule = base.getSubmodule();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Module> getImplementedInterface() {
            return Module.class;
        }

        @Override
        public ModuleKey key() {
            return this.key;
        }

        @Override
        public Module.ConformanceType getConformanceType() {
            return this._conformanceType;
        }

        @Override
        public List<Deviation> getDeviation() {
            return this._deviation;
        }

        @Override
        public List<YangIdentifier> getFeature() {
            return this._feature;
        }

        @Override
        public YangIdentifier getName() {
            return this._name;
        }

        @Override
        public Uri getNamespace() {
            return this._namespace;
        }

        @Override
        public CommonLeafs.Revision getRevision() {
            return this._revision;
        }

        @Override
        public Uri getSchema() {
            return this._schema;
        }

        @Override
        public List<Submodule> getSubmodule() {
            return this._submodule;
        }

        public <E$$ extends Augmentation<Module>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._conformanceType);
            result = 31 * result + Objects.hashCode(this._deviation);
            result = 31 * result + Objects.hashCode(this._feature);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._namespace);
            result = 31 * result + Objects.hashCode(this._revision);
            result = 31 * result + Objects.hashCode(this._schema);
            result = 31 * result + Objects.hashCode(this._submodule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Module.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Module other = (Module)obj;
            if (!Objects.equals((Object)this._conformanceType, (Object)other.getConformanceType())) {
                return false;
            }
            if (!Objects.equals(this._deviation, other.getDeviation())) {
                return false;
            }
            if (!Objects.equals(this._feature, other.getFeature())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._namespace, other.getNamespace())) {
                return false;
            }
            if (!Objects.equals(this._revision, other.getRevision())) {
                return false;
            }
            if (!Objects.equals(this._schema, other.getSchema())) {
                return false;
            }
            if (!Objects.equals(this._submodule, other.getSubmodule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ModuleImpl otherImpl = (ModuleImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Module>>, Augmentation<Module>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Module");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_conformanceType", (Object)((Object)this._conformanceType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_deviation", this._deviation);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_feature", this._feature);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_namespace", (Object)this._namespace);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_revision", (Object)this._revision);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_schema", (Object)this._schema);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_submodule", this._submodule);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

