/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ForwardingObject;
import java.util.Objects;
import java.util.function.Function;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.compat.DOMDataTreeReadTransactionAdapter;
import org.opendaylight.controller.sal.core.compat.DOMDataTreeReadWriteTransactionAdapter;
import org.opendaylight.controller.sal.core.compat.DOMDataTreeWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;

@Deprecated
public class DOMTransactionChainAdapter
extends ForwardingObject
implements DOMTransactionChain,
TransactionChainListener {
    private final Cache<AsyncTransaction<?, ?>, DOMDataTreeTransaction> transactions = CacheBuilder.newBuilder().weakKeys().weakValues().build();
    private final DOMTransactionChainListener listener;
    private final org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain delegate;

    public DOMTransactionChainAdapter(DOMTransactionChainListener listener, Function<TransactionChainListener, org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain> function) {
        this.listener = Objects.requireNonNull(listener);
        this.delegate = function.apply(this);
    }

    public void close() {
        this.delegate().close();
        this.transactions.invalidateAll();
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        DOMDataReadOnlyTransaction tx = this.delegate.newReadOnlyTransaction();
        return this.track((AsyncTransaction<?, ?>)tx, (DOMDataTreeTransaction)new DOMDataTreeReadTransactionAdapter(tx){

            @Override
            public void close() {
                DOMTransactionChainAdapter.this.untrack((AsyncTransaction<?, ?>)this.delegate());
                super.close();
            }
        });
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        DOMDataWriteTransaction tx = this.delegate.newWriteOnlyTransaction();
        return this.track((AsyncTransaction<?, ?>)tx, (DOMDataTreeTransaction)new DOMDataTreeWriteTransactionAdapter(tx){

            @Override
            public boolean cancel() {
                DOMTransactionChainAdapter.this.untrack((AsyncTransaction<?, ?>)this.delegate());
                return super.cancel();
            }
        });
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        DOMDataReadWriteTransaction tx = this.delegate.newReadWriteTransaction();
        return this.track((AsyncTransaction<?, ?>)tx, (DOMDataTreeTransaction)new DOMDataTreeReadWriteTransactionAdapter(tx){

            @Override
            public boolean cancel() {
                DOMTransactionChainAdapter.this.untrack((AsyncTransaction<?, ?>)this.delegate());
                return super.cancel();
            }

            @Override
            public void close() {
                DOMTransactionChainAdapter.this.untrack((AsyncTransaction<?, ?>)this.delegate());
                super.close();
            }
        });
    }

    public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, null, cause);
    }

    public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
        this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
    }

    protected org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain delegate() {
        return this.delegate;
    }

    private <T extends DOMDataTreeTransaction> T track(AsyncTransaction<?, ?> controllerTx, T mdsalTx) {
        this.transactions.put(controllerTx, mdsalTx);
        return mdsalTx;
    }

    void untrack(AsyncTransaction<?, ?> controllerTx) {
        this.transactions.invalidate(controllerTx);
    }
}

