/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.compat;

import com.google.common.base.Optional;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.common.api.MappingCheckedFuture;
import org.opendaylight.controller.md.sal.common.api.data.DataStoreUnavailableException;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainClosedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.sal.core.compat.ReadFailedExceptionAdapter;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public class LegacyDOMDataBrokerAdapter
extends ForwardingObject
implements DOMDataBroker {
    private static final ExceptionMapper<org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException> COMMIT_EX_MAPPER = new ExceptionMapper<org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException>("commit", org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException.class){

        protected org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException newWithCause(String message, Throwable cause) {
            if (cause instanceof OptimisticLockFailedException) {
                return new org.opendaylight.controller.md.sal.common.api.data.OptimisticLockFailedException(cause.getMessage(), cause.getCause());
            }
            if (cause instanceof TransactionCommitFailedException) {
                Throwable rootCause = cause.getCause();
                if (rootCause instanceof org.opendaylight.mdsal.common.api.DataStoreUnavailableException) {
                    rootCause = new DataStoreUnavailableException(rootCause.getMessage(), rootCause.getCause());
                }
                return new org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException(cause.getMessage(), rootCause, new RpcError[0]);
            }
            return new org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException(message, cause, new RpcError[0]);
        }
    };
    private final org.opendaylight.mdsal.dom.api.DOMDataBroker delegate;
    private final ClassToInstanceMap<DOMDataBrokerExtension> extensions;

    public LegacyDOMDataBrokerAdapter(org.opendaylight.mdsal.dom.api.DOMDataBroker delegate) {
        org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry delegateCohortRegistry;
        this.delegate = delegate;
        ClassToInstanceMap delegateExtensions = delegate.getExtensions();
        ImmutableClassToInstanceMap.Builder extBuilder = ImmutableClassToInstanceMap.builder();
        final DOMDataTreeChangeService delegateTreeChangeService = (DOMDataTreeChangeService)delegateExtensions.get(DOMDataTreeChangeService.class);
        if (delegateTreeChangeService != null) {
            extBuilder.put(org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService.class, (Object)new org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService(){

                public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier treeId, final L listener) {
                    ProxyListener delegateListener = listener instanceof ClusteredDOMDataTreeChangeListener ? new ClusteredProxyListener(listener) : new ProxyListener(listener);
                    final ListenerRegistration reg = delegateTreeChangeService.registerDataTreeChangeListener(treeId.toMdsal(), (org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener)delegateListener);
                    return new ListenerRegistration<L>(){

                        public L getInstance() {
                            return listener;
                        }

                        public void close() {
                            reg.close();
                        }
                    };
                }
            });
        }
        if ((delegateCohortRegistry = (org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry)delegateExtensions.get(org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry.class)) != null) {
            extBuilder.put(DOMDataTreeCommitCohortRegistry.class, (arg_0, arg_1) -> ((org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry)delegateCohortRegistry).registerCommitCohort(arg_0, arg_1));
        }
        this.extensions = extBuilder.build();
    }

    protected org.opendaylight.mdsal.dom.api.DOMDataBroker delegate() {
        return this.delegate;
    }

    public Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> getSupportedExtensions() {
        return this.extensions;
    }

    public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        return new DOMDataReadOnlyTransactionAdapter(this.delegate().newReadOnlyTransaction());
    }

    public DOMDataReadWriteTransaction newReadWriteTransaction() {
        return new DOMDataTransactionAdapter(this.delegate().newReadWriteTransaction());
    }

    public DOMDataWriteTransaction newWriteOnlyTransaction() {
        return new DOMDataTransactionAdapter(this.delegate().newWriteOnlyTransaction());
    }

    public org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain createTransactionChain(final TransactionChainListener listener) {
        final AtomicReference<4> legacyChain = new AtomicReference<4>();
        DOMTransactionChainListener delegateListener = new DOMTransactionChainListener(){

            public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
                listener.onTransactionChainFailed((TransactionChain)legacyChain.get(), () -> transaction.getIdentifier(), cause instanceof Exception ? COMMIT_EX_MAPPER.apply((Exception)cause) : cause);
            }

            public void onTransactionChainSuccessful(DOMTransactionChain chain) {
                listener.onTransactionChainSuccessful((TransactionChain)legacyChain.get());
            }
        };
        final DOMTransactionChain delegateChain = this.delegate().createTransactionChain(delegateListener);
        legacyChain.set(new org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain(){

            public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
                return new DOMDataReadOnlyTransactionAdapter(LegacyDOMDataBrokerAdapter.wrapException(() -> ((DOMTransactionChain)delegateChain).newReadOnlyTransaction()));
            }

            public DOMDataReadWriteTransaction newReadWriteTransaction() {
                return new DOMDataTransactionAdapter(LegacyDOMDataBrokerAdapter.wrapException(() -> ((DOMTransactionChain)delegateChain).newReadWriteTransaction()));
            }

            public DOMDataWriteTransaction newWriteOnlyTransaction() {
                return new DOMDataTransactionAdapter(LegacyDOMDataBrokerAdapter.wrapException(() -> ((DOMTransactionChain)delegateChain).newWriteOnlyTransaction()));
            }

            public void close() {
                delegateChain.close();
            }
        });
        return (org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain)legacyChain.get();
    }

    static <T> T wrapException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (DOMTransactionChainClosedException e) {
            throw new TransactionChainClosedException("Transaction chain already closed", (Throwable)e);
        }
    }

    private static final class ClusteredProxyListener
    extends ProxyListener
    implements org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener {
        ClusteredProxyListener(DOMDataTreeChangeListener delegate) {
            super(delegate);
        }
    }

    private static class ProxyListener
    extends ForwardingObject
    implements org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener {
        private final DOMDataTreeChangeListener delegate;

        ProxyListener(DOMDataTreeChangeListener delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
            this.delegate.onDataTreeChanged(changes);
        }

        protected DOMDataTreeChangeListener delegate() {
            return this.delegate;
        }
    }

    private static class DOMDataReadOnlyTransactionAdapter
    implements DOMDataReadOnlyTransaction {
        private final DOMDataTransactionAdapter adapter;

        DOMDataReadOnlyTransactionAdapter(DOMDataTreeReadTransaction delegateTx) {
            this.adapter = new DOMDataTransactionAdapter(delegateTx);
        }

        public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return this.adapter.read(store, path);
        }

        public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return this.adapter.exists(store, path);
        }

        public Object getIdentifier() {
            return this.adapter.getIdentifier();
        }

        public void close() {
            this.adapter.readDelegate().close();
        }
    }

    private static class DOMDataTransactionAdapter
    implements DOMDataReadWriteTransaction {
        private final DOMDataTreeReadTransaction readDelegate;
        private final DOMDataTreeWriteTransaction writeDelegate;
        private final Object identifier;

        DOMDataTransactionAdapter(@NonNull DOMDataTreeReadTransaction readDelegate) {
            this.readDelegate = Objects.requireNonNull(readDelegate);
            this.identifier = readDelegate.getIdentifier();
            this.writeDelegate = null;
        }

        DOMDataTransactionAdapter(@NonNull DOMDataTreeWriteTransaction writeDelegate) {
            this.writeDelegate = Objects.requireNonNull(writeDelegate);
            this.identifier = writeDelegate.getIdentifier();
            this.readDelegate = null;
        }

        DOMDataTransactionAdapter(@NonNull DOMDataTreeReadWriteTransaction rwDelegate) {
            this.readDelegate = (DOMDataTreeReadTransaction)Objects.requireNonNull(rwDelegate);
            this.writeDelegate = rwDelegate;
            this.identifier = this.readDelegate.getIdentifier();
        }

        DOMDataTreeReadTransaction readDelegate() {
            return this.readDelegate;
        }

        DOMDataTreeWriteTransaction writeDelegate() {
            return this.writeDelegate;
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return MappingCheckedFuture.create((ListenableFuture)this.readDelegate().read(store.toMdsal(), path).transform(Optional::fromJavaUtil, MoreExecutors.directExecutor()), (Function)((Object)ReadFailedExceptionAdapter.INSTANCE));
        }

        public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return MappingCheckedFuture.create((ListenableFuture)this.readDelegate().exists(store.toMdsal(), path), (Function)((Object)ReadFailedExceptionAdapter.INSTANCE));
        }

        public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
            this.writeDelegate().delete(store.toMdsal(), path);
        }

        public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            this.writeDelegate().put(store.toMdsal(), path, data);
        }

        public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            this.writeDelegate().merge(store.toMdsal(), path, data);
        }

        public boolean cancel() {
            return this.writeDelegate().cancel();
        }

        public FluentFuture<? extends CommitInfo> commit() {
            final SettableFuture resultFuture = SettableFuture.create();
            this.writeDelegate().commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    resultFuture.set((Object)result);
                }

                public void onFailure(Throwable ex) {
                    if (ex instanceof Exception) {
                        resultFuture.setException((Throwable)COMMIT_EX_MAPPER.apply((Exception)ex));
                    } else {
                        resultFuture.setException(ex);
                    }
                }
            }, MoreExecutors.directExecutor());
            return resultFuture;
        }
    }
}

