/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.mdsal.connector.DOMDataTransactionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionProvider.class);
    private final DOMDataBroker dataBroker;
    private DOMDataTreeReadWriteTransaction candidateTransaction = null;
    private DOMDataTreeReadWriteTransaction runningTransaction = null;
    private final List<DOMDataTreeReadWriteTransaction> allOpenReadWriteTransactions = new ArrayList<DOMDataTreeReadWriteTransaction>();
    private final DOMDataTransactionValidator transactionValidator;
    private final String netconfSessionIdForReporting;
    private static final String NO_TRANSACTION_FOUND_FOR_SESSION = "No candidateTransaction found for session ";

    public TransactionProvider(DOMDataBroker dataBroker, String netconfSessionIdForReporting) {
        this.dataBroker = dataBroker;
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
        this.transactionValidator = (DOMDataTransactionValidator)dataBroker.getExtensions().getInstance(DOMDataTransactionValidator.class);
    }

    @Override
    public synchronized void close() {
        for (DOMDataTreeReadWriteTransaction rwt : this.allOpenReadWriteTransactions) {
            rwt.cancel();
        }
        this.allOpenReadWriteTransactions.clear();
    }

    public synchronized Optional<DOMDataTreeReadWriteTransaction> getCandidateTransaction() {
        if (this.candidateTransaction == null) {
            return Optional.absent();
        }
        return Optional.of((Object)this.candidateTransaction);
    }

    public synchronized DOMDataTreeReadWriteTransaction getOrCreateTransaction() {
        if (this.getCandidateTransaction().isPresent()) {
            return (DOMDataTreeReadWriteTransaction)this.getCandidateTransaction().get();
        }
        this.candidateTransaction = this.dataBroker.newReadWriteTransaction();
        this.allOpenReadWriteTransactions.add(this.candidateTransaction);
        return this.candidateTransaction;
    }

    public synchronized void validateTransaction() throws DocumentedException {
        if (this.transactionValidator == null) {
            LOG.error("Validate capability is not supported");
            throw new DocumentedException("Validate capability is not supported", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.OPERATION_NOT_SUPPORTED, DocumentedException.ErrorSeverity.ERROR);
        }
        if (!this.getCandidateTransaction().isPresent()) {
            LOG.debug("Validating empty candidate transaction for session {}", (Object)this.netconfSessionIdForReporting);
            return;
        }
        try {
            this.transactionValidator.validate((DOMDataTreeWriteTransaction)this.candidateTransaction).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Candidate transaction validation {} failed on session {}", new Object[]{this.candidateTransaction, this.netconfSessionIdForReporting, e});
            String cause = e.getCause() != null ? " Cause: " + e.getCause().getMessage() : "";
            throw new DocumentedException("Candidate transaction validate failed [sessionId=" + this.netconfSessionIdForReporting + "]: " + e.getMessage() + cause, e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR);
        }
    }

    public synchronized boolean commitTransaction() throws DocumentedException {
        if (!this.getCandidateTransaction().isPresent()) {
            LOG.debug("Making commit without open candidate transaction for session {}", (Object)this.netconfSessionIdForReporting);
            return true;
        }
        FluentFuture future = this.candidateTransaction.commit();
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Transaction {} failed on", (Object)this.candidateTransaction, (Object)e);
            String cause = e.getCause() != null ? " Cause: " + e.getCause().getMessage() : "";
            throw new DocumentedException("Transaction commit failed on " + e.getMessage() + " " + this.netconfSessionIdForReporting + cause, e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR);
        }
        finally {
            this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
            this.candidateTransaction = null;
        }
        return true;
    }

    public synchronized void abortTransaction() {
        LOG.debug("Aborting current candidateTransaction");
        Optional<DOMDataTreeReadWriteTransaction> otx = this.getCandidateTransaction();
        if (!otx.isPresent()) {
            LOG.warn("discard-changes triggerd on an empty transaction for session: {}", (Object)this.netconfSessionIdForReporting);
            return;
        }
        this.candidateTransaction.cancel();
        this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
        this.candidateTransaction = null;
    }

    public synchronized DOMDataTreeReadWriteTransaction createRunningTransaction() {
        this.runningTransaction = this.dataBroker.newReadWriteTransaction();
        this.allOpenReadWriteTransactions.add(this.runningTransaction);
        return this.runningTransaction;
    }

    public synchronized void abortRunningTransaction(DOMDataTreeReadWriteTransaction tx) {
        LOG.debug("Aborting current running Transaction");
        Preconditions.checkState((this.runningTransaction != null ? 1 : 0) != 0, (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.netconfSessionIdForReporting));
        tx.cancel();
        this.allOpenReadWriteTransactions.remove(tx);
    }
}

