/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Commit
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private static final String OPERATION_NAME = "commit";
    private final TransactionProvider transactionProvider;

    public Commit(String netconfSessionIdForReporting, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        boolean commitStatus = this.transactionProvider.commitTransaction();
        LOG.trace("Commit completed successfully {}", (Object)commitStatus);
        return document.createElement("ok");
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

