/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DataTreeChangeTracker {
    private final ModifyAction defaultAction;
    private final Deque<ModifyAction> actions;
    private final Deque<YangInstanceIdentifier.PathArgument> currentPath;
    private final ArrayList<DataTreeChange> dataTreeChanges;
    private int deleteOperationTracker = 0;
    private int removeOperationTracker = 0;

    public DataTreeChangeTracker(ModifyAction defaultAction) {
        this.defaultAction = defaultAction;
        this.currentPath = new ArrayDeque<YangInstanceIdentifier.PathArgument>();
        this.actions = new ArrayDeque<ModifyAction>();
        this.dataTreeChanges = new ArrayList();
    }

    public void pushAction(ModifyAction action) {
        if (ModifyAction.DELETE.equals((Object)action)) {
            ++this.deleteOperationTracker;
        }
        if (ModifyAction.REMOVE.equals((Object)action)) {
            ++this.removeOperationTracker;
        }
        this.actions.push(action);
    }

    public ModifyAction peekAction() {
        return this.actions.peekFirst();
    }

    public ModifyAction popAction() {
        ModifyAction popResult = this.actions.pop();
        if (ModifyAction.DELETE.equals((Object)popResult)) {
            --this.deleteOperationTracker;
        }
        if (ModifyAction.REMOVE.equals((Object)popResult)) {
            --this.removeOperationTracker;
        }
        return popResult;
    }

    public int getDeleteOperationTracker() {
        return this.deleteOperationTracker;
    }

    public int getRemoveOperationTracker() {
        return this.removeOperationTracker;
    }

    public void addDataTreeChange(DataTreeChange change) {
        this.dataTreeChanges.add(change);
    }

    public ArrayList<DataTreeChange> getDataTreeChanges() {
        return this.dataTreeChanges;
    }

    public ModifyAction getDefaultAction() {
        return this.defaultAction;
    }

    public void pushPath(YangInstanceIdentifier.PathArgument pathArgument) {
        this.currentPath.push(pathArgument);
    }

    public YangInstanceIdentifier.PathArgument popPath() {
        return this.currentPath.pop();
    }

    public Deque<YangInstanceIdentifier.PathArgument> getCurrentPath() {
        return this.currentPath;
    }

    public static final class DataTreeChange {
        private final NormalizedNode<?, ?> changeRoot;
        private final ModifyAction action;
        private final List<YangInstanceIdentifier.PathArgument> path;

        public DataTreeChange(NormalizedNode<?, ?> changeRoot, ModifyAction action, ArrayList<YangInstanceIdentifier.PathArgument> path) {
            this.changeRoot = changeRoot;
            this.action = action;
            this.path = Lists.reverse(path);
        }

        public NormalizedNode<?, ?> getChangeRoot() {
            return this.changeRoot;
        }

        public ModifyAction getAction() {
            return this.action;
        }

        public List<YangInstanceIdentifier.PathArgument> getPath() {
            return this.path;
        }
    }
}

