/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.opendaylight.netconf.mdsal.connector.ops.DataTreeChangeTracker;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditConfigInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;

final class EditOperationNormalizedNodeStreamWriter
extends ImmutableNormalizedNodeStreamWriter
implements NormalizedNodeStreamAttributeWriter {
    private static final QName OPERATION_ATTRIBUTE = QName.create((URI)EditConfigInput.QNAME.getNamespace(), (String)"operation");
    private final DataTreeChangeTracker dataTreeChangeTracker;

    EditOperationNormalizedNodeStreamWriter(NormalizedNodeResult result, DataTreeChangeTracker dataTreeChangeTracker) {
        super(result);
        this.dataTreeChangeTracker = dataTreeChangeTracker;
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value, Map<QName, String> attributes) {
        super.leafNode(name, value);
        String operation = attributes.get(OPERATION_ATTRIBUTE);
        if (operation == null) {
            return;
        }
        ModifyAction action = ModifyAction.fromXmlValue((String)operation);
        if (this.dataTreeChangeTracker.getDeleteOperationTracker() == 0 && this.dataTreeChangeTracker.getRemoveOperationTracker() == 0 && !action.equals((Object)this.dataTreeChangeTracker.peekAction())) {
            LeafNode node = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)name, (Object)value);
            this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
            this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange((NormalizedNode<?, ?>)node, action, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
            this.getCurrent().removeChild(this.dataTreeChangeTracker.popPath());
        }
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startLeafSet(name, childSizeHint);
        this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startOrderedLeafSet(name, childSizeHint);
        this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void leafSetEntryNode(QName name, Object value, Map<QName, String> attributes) {
        super.leafSetEntryNode(name, value);
        String operation = attributes.get(OPERATION_ATTRIBUTE);
        if (operation == null) {
            return;
        }
        ModifyAction action = ModifyAction.fromXmlValue((String)operation);
        if (this.dataTreeChangeTracker.getDeleteOperationTracker() == 0 && this.dataTreeChangeTracker.getRemoveOperationTracker() == 0 && !action.equals((Object)this.dataTreeChangeTracker.peekAction())) {
            LeafSetEntryNode node = (LeafSetEntryNode)Builders.leafSetEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(name, value)).withValue(value).build();
            this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)node.getIdentifier());
            this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange((NormalizedNode<?, ?>)node, action, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
            this.getCurrent().removeChild(this.dataTreeChangeTracker.popPath());
        }
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) {
        super.startContainerNode(name, childSizeHint);
        this.trackDataContainerNode((YangInstanceIdentifier.PathArgument)name, attributes);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) {
        super.startYangModeledAnyXmlNode(name, childSizeHint);
        this.trackDataContainerNode((YangInstanceIdentifier.PathArgument)name, attributes);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startUnkeyedList(name, childSizeHint);
        this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint, Map<QName, String> attributes) {
        super.startUnkeyedListItem(name, childSizeHint);
        this.trackDataContainerNode((YangInstanceIdentifier.PathArgument)name, attributes);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startMapNode(name, childSizeHint);
        this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startOrderedMapNode(name, childSizeHint);
        this.dataTreeChangeTracker.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint, Map<QName, String> attributes) {
        super.startMapEntryNode(identifier, childSizeHint);
        this.trackDataContainerNode((YangInstanceIdentifier.PathArgument)identifier, attributes);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        super.startAugmentationNode(identifier);
        this.trackMixinNode((YangInstanceIdentifier.PathArgument)identifier);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        super.startChoiceNode(name, childSizeHint);
        this.trackMixinNode((YangInstanceIdentifier.PathArgument)name);
    }

    private void trackMixinNode(YangInstanceIdentifier.PathArgument identifier) {
        this.dataTreeChangeTracker.pushPath(identifier);
        this.dataTreeChangeTracker.pushAction(this.dataTreeChangeTracker.peekAction() != null ? this.dataTreeChangeTracker.peekAction() : this.dataTreeChangeTracker.getDefaultAction());
    }

    private void trackDataContainerNode(YangInstanceIdentifier.PathArgument identifier, Map<QName, String> attributes) {
        this.dataTreeChangeTracker.pushPath(identifier);
        String operation = attributes.get(OPERATION_ATTRIBUTE);
        if (operation != null) {
            this.dataTreeChangeTracker.pushAction(ModifyAction.fromXmlValue((String)operation));
        } else {
            this.dataTreeChangeTracker.pushAction(this.dataTreeChangeTracker.peekAction() != null ? this.dataTreeChangeTracker.peekAction() : this.dataTreeChangeTracker.getDefaultAction());
        }
    }

    public void endNode() {
        NormalizedNodeContainerBuilder finishedBuilder = (NormalizedNodeContainerBuilder)this.getBuilders().peek();
        NormalizedNode product = finishedBuilder.build();
        super.endNode();
        if (finishedBuilder instanceof DataContainerNodeBuilder) {
            ModifyAction currentAction = this.dataTreeChangeTracker.popAction();
            if (this.dataTreeChangeTracker.getDeleteOperationTracker() > 0 || this.dataTreeChangeTracker.getRemoveOperationTracker() > 0) {
                this.dataTreeChangeTracker.popPath();
            } else if (!currentAction.equals((Object)this.dataTreeChangeTracker.peekAction())) {
                this.dataTreeChangeTracker.addDataTreeChange(new DataTreeChangeTracker.DataTreeChange(product, currentAction, new ArrayList<YangInstanceIdentifier.PathArgument>(this.dataTreeChangeTracker.getCurrentPath())));
                if (this.getCurrent() instanceof ImmutableNormalizedNodeStreamWriter.NormalizedNodeResultBuilder) {
                    this.dataTreeChangeTracker.popPath();
                    return;
                }
                this.getCurrent().removeChild(this.dataTreeChangeTracker.popPath());
            } else {
                this.dataTreeChangeTracker.popPath();
                return;
            }
        }
        if (finishedBuilder instanceof CollectionNodeBuilder) {
            this.dataTreeChangeTracker.popPath();
        }
    }
}

