/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops.get;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.netconf.mdsal.connector.ops.get.FilterContentValidator;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractGet
extends AbstractSingletonNetconfOperation {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY;
    private static final YangInstanceIdentifier ROOT;
    private static final String FILTER = "filter";
    protected final CurrentSchemaContext schemaContext;
    private final FilterContentValidator validator;

    public AbstractGet(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
        this.validator = new FilterContentValidator(schemaContext);
    }

    protected Node transformNormalizedNode(Document document, NormalizedNode<?, ?> data, YangInstanceIdentifier dataRoot) {
        DOMResult result = new DOMResult(document.createElement("data"));
        XMLStreamWriter xmlWriter = AbstractGet.getXmlStreamWriter(result);
        NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)this.schemaContext.getCurrentContext(), (SchemaPath)AbstractGet.getSchemaPath(dataRoot));
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter, (boolean)true);
        AbstractGet.writeRootElement(xmlWriter, nnWriter, (ContainerNode)data);
        return result.getNode();
    }

    private static XMLStreamWriter getXmlStreamWriter(DOMResult result) {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private static SchemaPath getSchemaPath(YangInstanceIdentifier dataRoot) {
        return SchemaPath.create((Iterable)Iterables.transform((Iterable)dataRoot.getPathArguments(), YangInstanceIdentifier.PathArgument::getNodeType), (boolean)dataRoot.equals((Object)ROOT));
    }

    private static void writeRootElement(XMLStreamWriter xmlWriter, NormalizedNodeWriter nnWriter, ContainerNode data) {
        try {
            if (data.getNodeType().equals((Object)SchemaContext.NAME)) {
                for (DataContainerChild child : data.getValue()) {
                    nnWriter.write((NormalizedNode)child);
                }
            } else {
                nnWriter.write((NormalizedNode)data);
            }
            nnWriter.flush();
            xmlWriter.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element serializeNodeWithParentStructure(Document document, YangInstanceIdentifier dataRoot, NormalizedNode<?, ?> node) {
        if (!dataRoot.equals((Object)ROOT)) {
            return (Element)this.transformNormalizedNode(document, ImmutableNodes.fromInstanceId((SchemaContext)this.schemaContext.getCurrentContext(), (YangInstanceIdentifier)dataRoot, node), ROOT);
        }
        return (Element)this.transformNormalizedNode(document, node, ROOT);
    }

    protected Optional<YangInstanceIdentifier> getDataRootFromFilter(XmlElement operationElement) throws DocumentedException {
        Optional filterElement = operationElement.getOnlyChildElementOptionally(FILTER);
        if (filterElement.isPresent()) {
            if (((XmlElement)filterElement.get()).getChildElements().size() == 0) {
                return Optional.empty();
            }
            return Optional.of(this.getInstanceIdentifierFromFilter((XmlElement)filterElement.get()));
        }
        return Optional.of(ROOT);
    }

    @VisibleForTesting
    protected YangInstanceIdentifier getInstanceIdentifierFromFilter(XmlElement filterElement) throws DocumentedException {
        if (filterElement.getChildElements().size() != 1) {
            throw new DocumentedException("Multiple filter roots not supported yet", DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_NOT_SUPPORTED, DocumentedException.ErrorSeverity.ERROR);
        }
        XmlElement element = filterElement.getOnlyChildElement();
        return this.validator.validate(element);
    }

    static {
        ROOT = YangInstanceIdentifier.EMPTY;
        XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    protected static final class GetConfigExecution {
        private final Optional<Datastore> datastore;

        GetConfigExecution(Optional<Datastore> datastore) {
            this.datastore = datastore;
        }

        static GetConfigExecution fromXml(XmlElement xml, String operationName) throws DocumentedException {
            Optional<Datastore> sourceDatastore;
            try {
                GetConfigExecution.validateInputRpc(xml, operationName);
            }
            catch (DocumentedException e) {
                throw new DocumentedException("Incorrect RPC: " + e.getMessage(), (Exception)((Object)e), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            try {
                sourceDatastore = GetConfigExecution.parseSource(xml);
            }
            catch (DocumentedException e) {
                throw new DocumentedException("Get-config source attribute error: " + e.getMessage(), (Exception)((Object)e), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            return new GetConfigExecution(sourceDatastore);
        }

        private static Optional<Datastore> parseSource(XmlElement xml) throws DocumentedException {
            Optional sourceElement = xml.getOnlyChildElementOptionally("source", "urn:ietf:params:xml:ns:netconf:base:1.0");
            return sourceElement.isPresent() ? Optional.of(Datastore.valueOf(((XmlElement)sourceElement.get()).getOnlyChildElement().getName())) : Optional.empty();
        }

        private static void validateInputRpc(XmlElement xml, String operationName) throws DocumentedException {
            xml.checkName(operationName);
            xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        }

        public Optional<Datastore> getDatastore() {
            return this.datastore;
        }
    }
}

