/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops.get;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.netconf.mdsal.connector.ops.get.AbstractGet;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Get
extends AbstractGet {
    private static final Logger LOG = LoggerFactory.getLogger(Get.class);
    private static final String OPERATION_NAME = "get";
    private final TransactionProvider transactionProvider;

    public Get(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting, schemaContext);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        Optional<YangInstanceIdentifier> dataRootOptional = this.getDataRootFromFilter(operationElement);
        if (!dataRootOptional.isPresent()) {
            return document.createElement("data");
        }
        YangInstanceIdentifier dataRoot = dataRootOptional.get();
        DOMDataTreeReadWriteTransaction rwTx = this.getTransaction(Datastore.running);
        try {
            Optional normalizedNodeOptional = (Optional)rwTx.read(LogicalDatastoreType.OPERATIONAL, dataRoot).get();
            this.transactionProvider.abortRunningTransaction(rwTx);
            if (!normalizedNodeOptional.isPresent()) {
                return document.createElement("data");
            }
            return this.serializeNodeWithParentStructure(document, dataRoot, (NormalizedNode)normalizedNodeOptional.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to read data: {}", (Object)dataRoot, (Object)e);
            throw new IllegalStateException("Unable to read data " + dataRoot, e);
        }
    }

    private DOMDataTreeReadWriteTransaction getTransaction(Datastore datastore) throws DocumentedException {
        if (datastore == Datastore.candidate) {
            return this.transactionProvider.getOrCreateTransaction();
        }
        if (datastore == Datastore.running) {
            return this.transactionProvider.createRunningTransaction();
        }
        throw new DocumentedException("Incorrect Datastore: ", DocumentedException.ErrorType.PROTOCOL, DocumentedException.ErrorTag.BAD_ELEMENT, DocumentedException.ErrorSeverity.ERROR);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

