/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.jetty.openwebbeans.impl;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;
import org.ops4j.pax.cdi.jetty.openwebbeans.impl.JettyDecorator;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static Logger log = LoggerFactory.getLogger(OpenWebBeansListener.class);
    private ContainerLifecycle lifecycle;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        CdiContainer cdiContainer = (CdiContainer)context.getAttribute("org.ops4j.pax.cdi.container");
        cdiContainer.start((Object)event);
        WebBeansContext webBeansContext = (WebBeansContext)cdiContainer.unwrap(WebBeansContext.class);
        this.lifecycle = (ContainerLifecycle)cdiContainer.unwrap(ContainerLifecycle.class);
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        Injector injector = new Injector(cdiContainer);
        context.setAttribute("org.ops4j.pax.cdi.injector", (Object)injector);
        JettyDecorator.register(context);
        context.setAttribute(BeanManager.class.getName(), (Object)manager);
    }

    public void requestInitialized(ServletRequestEvent event) {
        try {
            log.debug("Starting a new request : [{}]", (Object)(event == null ? "null" : event.getServletRequest().getRemoteAddr()));
            this.lifecycle.getContextService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            log.error(WebBeansLoggerFacade.constructMessage((String)"ERROR_0019", (Object[])new Object[]{event == null ? "null" : event.getServletRequest()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            log.debug("Starting a session with session id : [{}]", (Object)event.getSession().getId());
            this.lifecycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            log.error(WebBeansLoggerFacade.constructMessage((String)"ERROR_0020", (Object[])new Object[]{event.getSession()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute("org.ops4j.pax.cdi.container");
        this.cleanupRequestThreadLocals();
    }

    public void requestDestroyed(ServletRequestEvent event) {
        log.debug("Destroying a request : [{}]", (Object)(event == null ? "null" : event.getServletRequest().getRemoteAddr()));
        ELContextStore elStore = ELContextStore.getInstance((boolean)false);
        if (elStore != null) {
            elStore.destroyELContextStore();
        }
        this.lifecycle.getContextService().endContext(RequestScoped.class, (Object)event);
        this.cleanupRequestThreadLocals();
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        log.debug("Destroying a session with session id : [{}]", (Object)event.getSession().getId());
        boolean mustDestroy = this.ensureRequestScope();
        this.lifecycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        if (mustDestroy) {
            this.requestDestroyed(null);
        }
    }

    private boolean ensureRequestScope() {
        Context context = this.lifecycle.getContextService().getCurrentContext(RequestScoped.class);
        if (context == null || !context.isActive()) {
            this.requestInitialized(null);
            return true;
        }
        return false;
    }

    private void cleanupRequestThreadLocals() {
        ContextsService contextsService = this.lifecycle.getContextService();
        if (contextsService != null) {
            contextsService.removeThreadLocals();
        }
    }
}

